/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util.email;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.watchpoint.pmm.entities.Title;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.modelmbean.XMLParseException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EmailNotificationUtility {
    private static final Logger logger = Logger.getLogger(EmailNotificationUtility.class);
    private static final String PRODUCT_DIR = "com.tandbergtv.cms.product.dir";
    private static final String EMAIL_FILE_DIRECTORY = "conf" + File.separator + "contentMgmt";
    private static final String EMAIL_CONFIG_XML = "EmailConfig.xml";
    private static final String EMAIL_FILE_PATH = String.valueOf(EMAIL_FILE_DIRECTORY) + File.separator + "EmailConfig.xml";
    private static final String ERROR_ALIAS = "%%Error%%";
    private static Map<String, AssetTypeXpath> aliasXpathFields = null;

    public EmailNotificationUtility() throws XMLParseException {
        if (aliasXpathFields == null) {
            aliasXpathFields = EmailNotificationUtility.getAliasXpathFromXml();
        }
    }

    public static Map<String, AssetTypeXpath> getAliasXpathFromXml() throws XMLParseException {
        HashMap<String, AssetTypeXpath> aliasXpathFields = new HashMap<String, AssetTypeXpath>();
        try {
            Document doc;
            URL schemaUrl = EmailNotificationUtility.class.getResource("EmailFields.xsd");
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaUrl);
            DocumentBuilderFactory dbmFactory = DocumentBuilderFactory.newInstance();
            dbmFactory.setSchema(schema);
            DocumentBuilder builder = dbmFactory.newDocumentBuilder();
            File emailConfigFile = EmailNotificationUtility.getConfFile(EMAIL_FILE_PATH);
            if (emailConfigFile.exists()) {
                doc = builder.parse(emailConfigFile);
            } else {
                URL fileUrl = EmailNotificationUtility.class.getResource(EMAIL_CONFIG_XML);
                InputStream is = fileUrl.openStream();
                doc = builder.parse(is);
            }
            NodeList nodes = doc.getElementsByTagName("emailFields");
            int i = 0;
            while (i < nodes.getLength()) {
                Element e = (Element)nodes.item(i);
                String assetType = e.getAttribute("assetType");
                String xpath = e.getAttribute("xpath");
                String alias = e.getAttribute("alias");
                aliasXpathFields.put(alias, new AssetTypeXpath(xpath, assetType));
                ++i;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error while parsing xml for email subject fields.", (Throwable)ex);
            throw new XMLParseException();
        }
        return aliasXpathFields;
    }

    public Map<String, String> getAliasValueDetailsFromXml(Title title, String errorMsg) {
        HashMap<String, String> emailSubjectFields = new HashMap<String, String>();
        for (Map.Entry<String, AssetTypeXpath> aliasAssetTypeXpath : aliasXpathFields.entrySet()) {
            String alias = aliasAssetTypeXpath.getKey();
            String assetType = aliasAssetTypeXpath.getValue().getAssetType();
            String xpath = aliasAssetTypeXpath.getValue().getXpath();
            if (alias.compareTo(ERROR_ALIAS) != 0) {
                emailSubjectFields.put(alias, EmailNotificationUtility.getValueOfAliasFromXpath(title, assetType, xpath));
                continue;
            }
            emailSubjectFields.put(alias, errorMsg);
        }
        return emailSubjectFields;
    }

    public static File getConfFile(String filePath) {
        String installFolder = System.getProperty(PRODUCT_DIR);
        File emailConfigFile = new File(String.valueOf(installFolder) + File.separator + filePath);
        return emailConfigFile;
    }

    private static String getValueOfAliasFromXpath(Title title, String assetType, String xpath) {
        List fields;
        String fieldValue = "";
        Asset rootAsset = title.getAsset();
        if (rootAsset != null && (fields = rootAsset.getAllFieldsForXpath(assetType, xpath)) != null && fields.size() > 0) {
            fieldValue = ((Field)fields.get(0)).getValue();
        }
        return fieldValue;
    }

    static class AssetTypeXpath {
        String xpath;
        String assetType;

        public AssetTypeXpath(String xpath, String assetType) {
            this.xpath = xpath;
            this.assetType = assetType;
        }

        public String getXpath() {
            return this.xpath;
        }

        public String getAssetType() {
            return this.assetType;
        }
    }
}

