/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.search;

import java.util.ArrayList;
import java.util.List;

public class TitleSearchResult {
    private List<SearchRow> rows;
    private long count;
    private boolean hasMoreResults;

    public TitleSearchResult(List<SearchRow> rows, int count, boolean hasMoreResults) {
        this.rows = rows;
        this.count = count;
        this.hasMoreResults = hasMoreResults;
    }

    public TitleSearchResult() {
        this.rows = new ArrayList<SearchRow>();
        this.count = 0L;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public List<SearchRow> getRows() {
        return this.rows;
    }

    public void addRow(SearchRow row) {
        this.rows.add(row);
    }

    public SearchRow getRow(long id) {
        for (SearchRow row : this.rows) {
            if (row.id != id) continue;
            return row;
        }
        return null;
    }

    public boolean hasMoreResults() {
        return this.hasMoreResults;
    }

    public void setHasMoreResults(boolean hasMoreResults) {
        this.hasMoreResults = hasMoreResults;
    }

    public static class SearchRow {
        private long id;
        private List<Object> fields;

        public SearchRow(long id, List<Object> fields) {
            this.id = id;
            this.fields = fields;
        }

        public void setId(int id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public void setFields(List<Object> fields) {
            this.fields = fields;
        }

        public List<Object> getFields() {
            return this.fields;
        }

        public Object getValue(int index) {
            if (this.fields == null) {
                return null;
            }
            if (index < 0 || index >= this.fields.size()) {
                return null;
            }
            return this.fields.get(index);
        }

        public String getFirstValueAsString(int index) {
            if (this.fields == null) {
                return null;
            }
            if (index < 0 || index >= this.fields.size()) {
                return null;
            }
            Object obj = this.fields.get(index);
            if (obj instanceof List) {
                List list = (List)obj;
                if (list.isEmpty()) {
                    return null;
                }
                return String.valueOf(list.get(0));
            }
            return String.valueOf(obj);
        }

        public String getCSVs(int index) {
            if (this.fields == null) {
                return null;
            }
            if (index < 0 || index >= this.fields.size()) {
                return null;
            }
            Object obj = this.fields.get(index);
            if (obj instanceof List) {
                List list = (List)obj;
                if (list.isEmpty()) {
                    return null;
                }
                StringBuilder bld = new StringBuilder();
                for (int i = 0; i < list.size(); ++i) {
                    Object val = list.get(i);
                    if (val == null) continue;
                    if (i != 0) {
                        bld.append(", ");
                    }
                    bld.append(val.toString());
                }
                return String.valueOf(bld.toString());
            }
            return String.valueOf(obj);
        }
    }
}

