/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.content.contentclass.entities;

import com.tandbergtv.content.contentclass.entities.ContentClassOption;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ContentClassField
implements Serializable {
    private static final long serialVersionUID = 1946025321716873919L;
    private String path;
    private boolean disabled;
    private boolean hideInUIOnly;
    private boolean isLocked;
    private boolean isAttribute;
    private boolean isRequired;
    private FieldType fieldType;
    private Integer min;
    private Integer max;
    private boolean includeInBatch;
    private boolean isAutofillable;
    private String autofillProvider;
    private String displayPattern;
    private String defaultValue;
    private List<ContentClassOption> options;
    private Set<String> disabledOptionKeys;

    public ContentClassField(String path) {
        this.path = path;
    }

    public ContentClassField(ContentClassField copy) {
        this.fieldType = copy.fieldType;
        this.autofillProvider = copy.autofillProvider;
        this.defaultValue = copy.defaultValue;
        this.addDisabledOptionKeys(copy.getDisabledOptionKeys());
        this.displayPattern = copy.displayPattern;
        this.includeInBatch = copy.includeInBatch;
        this.isAttribute = copy.isAttribute;
        this.isAutofillable = copy.isAutofillable;
        this.isLocked = copy.isLocked;
        this.disabled = copy.disabled;
        this.isRequired = copy.isRequired;
        this.max = copy.max;
        this.min = copy.min;
        this.addOptions(copy.getOptions());
        this.path = copy.path;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(Boolean isLocked) {
        if (isLocked == null) {
            return;
        }
        this.isLocked = isLocked;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public List<ContentClassOption> getOptions() {
        return this.options;
    }

    public void addOption(ContentClassOption option) {
        if (option == null) {
            return;
        }
        if (this.options == null) {
            this.options = new ArrayList<ContentClassOption>();
        }
        this.options.add(option);
    }

    public void addOptions(Collection<ContentClassOption> newOptions) {
        if (newOptions == null || newOptions.isEmpty()) {
            return;
        }
        if (this.options == null) {
            this.options = new ArrayList<ContentClassOption>();
        }
        this.options.addAll(newOptions);
    }

    public Set<String> getDisabledOptionKeys() {
        return this.disabledOptionKeys;
    }

    public void addDisabledOptionKey(String key) {
        if (key == null) {
            return;
        }
        if (this.disabledOptionKeys == null) {
            this.disabledOptionKeys = new TreeSet<String>();
        }
        this.disabledOptionKeys.add(key);
    }

    public void addDisabledOptionKeys(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        if (this.disabledOptionKeys == null) {
            this.disabledOptionKeys = new TreeSet<String>();
        }
        this.disabledOptionKeys.addAll(keys);
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public void setAttribute(Boolean isAttribute) {
        if (isAttribute == null) {
            return;
        }
        this.isAttribute = isAttribute;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public boolean getIncludeInBatch() {
        return this.includeInBatch;
    }

    public void setIncludeInBatch(Boolean includeInBatch) {
        if (includeInBatch == null) {
            return;
        }
        this.includeInBatch = includeInBatch;
    }

    public boolean isAutofillable() {
        return this.isAutofillable;
    }

    public void setAutofillable(Boolean isAutofillable) {
        if (isAutofillable == null) {
            return;
        }
        this.isAutofillable = isAutofillable;
    }

    public String getAutofillProvider() {
        return this.autofillProvider;
    }

    public void setAutofillProvider(String autofillProvider) {
        this.autofillProvider = "null".equalsIgnoreCase(autofillProvider) ? null : autofillProvider;
    }

    public String getDisplayPattern() {
        return this.displayPattern;
    }

    public void setDisplayPattern(String displayPattern) {
        this.displayPattern = displayPattern;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(Boolean isRequired) {
        if (isRequired == null) {
            return;
        }
        this.isRequired = isRequired;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isEnabled() {
        return !this.isDisabled();
    }

    public void setDisabled(Boolean disabled) {
        if (disabled == null) {
            return;
        }
        this.disabled = disabled;
    }

    public boolean hideInUIOnly() {
        return this.hideInUIOnly;
    }

    public void setHideInUIOnly(Boolean hide) {
        if (hide == null) {
            return;
        }
        this.hideInUIOnly = hide;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public static enum FieldType {
        TEXT_BOX,
        TEXT_AREA,
        DROP_DOWN,
        COMBO_BOX;

    }
}

