/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.pmm.util;

import com.tandbergtv.watchpoint.pmm.entities.Title;
import com.tandbergtv.watchpoint.pmm.entities.TitleActionSource;
import com.tandbergtv.watchpoint.pmm.entities.TitleProcessingStatus;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.watchpoint.pmm.title.template.ITitleTemplateProvider;
import com.tandbergtv.watchpoint.routing.SoapRouter;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProcessingStatusUpdater {
    private static Logger logger = Logger.getLogger(ProcessingStatusUpdater.class);

    public static void updateProcessingStatus(Long titleId, TitleProcessingStatus processingStatus) {
        try {
            ITitleManager titleManager = SoapRouter.getTitleManager();
            if (titleManager != null && processingStatus != null) {
                Title masterTitle = null;
                if (!titleManager.isExisting(titleId)) {
                    return;
                }
                masterTitle = titleManager.get(titleId);
                if (masterTitle.isCopy()) {
                    return;
                }
                if (masterTitle.getProcessingStatus() != processingStatus) {
                    titleManager.saveProcessingStatus(masterTitle.getId(), processingStatus, new TitleActionSource());
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to update Processing Status", (Throwable)ex);
        }
    }

    private static boolean isContentProcessingTemplate(String templateName) {
        boolean result = false;
        if (templateName != null && !templateName.isEmpty()) {
            result = ProcessingStatusUpdater.getContentProcessingTemplates().contains(templateName);
        }
        return result;
    }

    private static Set<String> getContentProcessingTemplates() {
        long t1 = System.currentTimeMillis();
        HashSet<String> result = new HashSet<String>();
        try {
            ITitleTemplateProvider service = (ITitleTemplateProvider)ServiceRegistry.getDefault().lookup(ITitleTemplateProvider.class);
            HashSet<String> contentProcessingTemplates = new HashSet<String>(service.getTemplateNamesByCategory("ContentProcessing"));
            contentProcessingTemplates.addAll(service.getTemplateNamesByCategory("LocalContentProcessing"));
            for (String templateName : contentProcessingTemplates) {
                result.add(templateName);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to get Content Processing Templates", (Throwable)ex);
        }
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("Time taken to getContentProcessingTemplates - time:" + (t2 - t1) + " ms"));
        return result;
    }
}

