/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.routing;

import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.watchpoint.pmm.partner.IPartnerManagement;
import com.tandbergtv.watchpoint.pmm.title.ITitleManager;
import com.tandbergtv.workflow.adaptor.util.XMLDocumentUtility;
import com.tandbergtv.workflow.comm.IDestination;
import com.tandbergtv.workflow.comm.routing.CommunicationException;
import com.tandbergtv.workflow.comm.routing.IRoutingService;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.message.HTTPMessage;
import com.tandbergtv.workflow.message.HTTPPayload;
import com.tandbergtv.workflow.message.IMessage;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.util.WPCLConverter;
import java.io.StringReader;
import java.util.List;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class SoapRouter
implements IRoutingService {
    private static final String DESTINATION = "http://app:7070/workflow/services/AdaptorService";
    private static final String TITLE_MANAGER_SERVICE = "cms/TitleManagerProxy/local";
    private static final String PRIORITY = "priority";
    private static final String PROVIDER_ID = "providerId";
    private static final String TITLE_ID = "titleId";
    private static final String ENVELOPE_TEMPLATE = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Header/><soapenv:Body>WFS_MESSAGE</soapenv:Body></soapenv:Envelope>";
    private static Logger logger = Logger.getLogger(SoapRouter.class);

    public IMessage send(IMessage msg) throws CommunicationException {
        HTTPMessage responseMessage = null;
        try {
            SOAPMessage message = MessageFactory.newInstance().createMessage();
            message.getMimeHeaders().addHeader("SOAPAction", "");
            WorkflowMessage wfsmsg = new WPCLConverter().convert(msg);
            String titleId = wfsmsg.getPayload().getValue(TITLE_ID);
            String templateName = wfsmsg.getCommand().getParameterValue("_template");
            String msgContent = "";
            if (titleId != null && titleId.trim().length() > 0) {
                String providerId = wfsmsg.getPayload().getValue(PROVIDER_ID);
                if (providerId == null || providerId.trim().isEmpty()) {
                    Long partnerId = SoapRouter.getTitleManager().get(Long.valueOf(titleId)).getPartnerId();
                    providerId = SoapRouter.getPartnerManager().getPartner(partnerId).getProviderId();
                }
                wfsmsg.getPayload().putValue(PROVIDER_ID, providerId);
                if (wfsmsg.getCommand().getParameterValue(PRIORITY) == null) {
                    String priority = SoapRouter.getTitleManager().getPriority(Long.valueOf(titleId));
                    wfsmsg.getCommand().addParameter(PRIORITY, priority);
                }
                IMessage request = new WPCLConverter().convert(wfsmsg);
                msgContent = request.getPayload().getContent();
            } else {
                msgContent = msg.getPayload().getContent();
            }
            msgContent = msgContent.substring(msgContent.indexOf("?>") + 2);
            String envelopeInstance = ENVELOPE_TEMPLATE.replace("WFS_MESSAGE", msgContent);
            SOAPPart soapPart = message.getSOAPPart();
            soapPart.setContent((Source)new StreamSource(new StringReader(envelopeInstance)));
            logger.debug((Object)"Making SOAP call to http://app:7070/workflow/services/AdaptorService");
            SOAPConnection connection = SOAPConnectionFactory.newInstance().createConnection();
            SOAPMessage reply = connection.call(message, (Object)DESTINATION);
            SOAPBody body = reply.getSOAPBody();
            if (body.getFault() != null) {
                SOAPFault fault = body.getFault();
                logger.warn((Object)fault.getFaultString());
            }
            String response = XMLDocumentUtility.convertToString((Node)reply.getSOAPPart());
            responseMessage = new HTTPMessage(new HTTPPayload(response));
            logger.debug((Object)("responsemessage: " + responseMessage));
            connection.close();
        }
        catch (SOAPException ex) {
            throw new CommunicationException("Could not send SOAP message.", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new CommunicationException("Could not send xml from SOAP response message.", (Throwable)ex);
        }
        return responseMessage;
    }

    public WorkflowMessage send(WorkflowMessage arg0, List<IDestination> arg1) throws CommunicationException {
        throw new UnsupportedOperationException("This should not be called");
    }

    public static ITitleManager getTitleManager() {
        ITitleManager service = null;
        try {
            service = (ITitleManager)InjectionUtil.injectInstance((String)TITLE_MANAGER_SERVICE);
        }
        catch (RuntimeException e) {
            String msg = "Failed to lookup the Title Manager service(cms/TitleManagerProxy/local).";
            throw new RuntimeException(msg);
        }
        return service;
    }

    public static IPartnerManagement getPartnerManager() {
        return (IPartnerManagement)ServiceRegistry.getDefault().lookup(IPartnerManagement.class);
    }
}

