/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core;

import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.core.util.DateFormatter;
import com.tandbergtv.workflow.core.util.JsonObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WorkflowProcessNote
implements Serializable {
    private static final Logger logger = Logger.getLogger(WorkflowProcessNote.class);
    private static final String LINE_SEPARATOR = "\r\n";
    private static final long serialVersionUID = -5808568538517345232L;
    private long id;
    @Deprecated
    private volatile String text;
    private WorkflowProcess process;
    private List<Map<String, Serializable>> notes = new ArrayList<Map<String, Serializable>>();

    public WorkflowProcessNote() {
    }

    public WorkflowProcessNote(String text) {
        this.setText(text);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    public String getFormatedNotes() {
        if (this.notes.isEmpty() && StringUtils.isBlank((String)this.text)) {
            return "";
        }
        StringBuilder noteText = new StringBuilder(200);
        if (this.notes.isEmpty() && StringUtils.isNotBlank((String)this.text)) {
            this.parseLegacyNotes();
        }
        for (Map<String, Serializable> row : this.notes) {
            if (noteText.length() > 0) {
                noteText.append(LINE_SEPARATOR);
            }
            noteText.append("[");
            Long timestamp = Configuration.toLong("" + row.get("timestamp"), 0L);
            noteText.append(DateFormatter.toStandardDate(timestamp)).append(" ");
            noteText.append(row.get("user")).append("] ");
            noteText.append(StringUtils.trimToEmpty((String)("" + row.get("note"))));
        }
        return noteText.toString();
    }

    public void setText(String text) {
        this.text = text;
        this.parseLegacyNotes();
    }

    private void parseLegacyNotes() {
        if (StringUtils.isEmpty((String)this.text)) {
            return;
        }
        String[] lines = StringUtils.split((String)this.text, (String)"\n");
        this.notes.clear();
        for (String line : lines) {
            Map<String, Serializable> row = this.parseOneNote(line);
            this.notes.add(row);
        }
    }

    private Map<String, Serializable> parseOneNote(String line) {
        try {
            HashMap<String, Serializable> row = new HashMap<String, Serializable>();
            int endpositionForNote = line.lastIndexOf("[");
            String note = line.substring(0, endpositionForNote);
            String userAndTime = line.substring(endpositionForNote + 1, line.length() - 1);
            int atCharPostion = userAndTime.lastIndexOf("at ");
            String user = userAndTime.substring(0, atCharPostion);
            String date = StringUtils.trimToEmpty((String)userAndTime.substring(atCharPostion + 2));
            row.put("user", (Serializable)((Object)StringUtils.trimToEmpty((String)user)));
            row.put("note", (Serializable)((Object)StringUtils.trimToEmpty((String)note)));
            row.put("timestamp", Long.valueOf(DateFormatter.convertJavascriptTimeToJava(date).getTime()));
            return row;
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public List<Map<String, Serializable>> getNotes() {
        if (this.notes.isEmpty() && StringUtils.isNotBlank((String)this.text)) {
            this.parseLegacyNotes();
        }
        return this.notes;
    }

    public String getJsonFormattedNotes() {
        if (this.getNotes().isEmpty()) {
            return "";
        }
        try {
            return JsonObjectMapper.toJsonString(this.getNotes());
        }
        catch (Exception e) {
            logger.warn((Object)"Process Notes create date format error: ", (Throwable)e);
            return "";
        }
    }

    public void setNotes(List<Map<String, Serializable>> processNotes) {
        this.notes = processNotes;
    }

    public void setNotes(String processNotesJsonString) {
        if (StringUtils.isEmpty((String)processNotesJsonString) || processNotesJsonString.trim().equals("[]")) {
            this.notes.clear();
        }
        this.appendNotes(processNotesJsonString);
    }

    public WorkflowProcess getProcess() {
        return this.process;
    }

    public void setProcess(WorkflowProcess process) {
        this.process = process;
    }

    public void appendNotes(List<Map<String, Serializable>> items) {
        if (items == null || items.isEmpty()) {
            return;
        }
        this.notes.addAll(items);
    }

    public void appendNotes(String processNotesText) {
        if (StringUtils.isEmpty((String)processNotesText)) {
            return;
        }
        List<Map<String, Serializable>> items = JsonObjectMapper.toList(processNotesText);
        if (!items.isEmpty()) {
            this.appendNotes(items);
        }
    }
}

