/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.graph;

import com.tandbergtv.workflow.core.Datatype;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.jbpm.JbpmException;

public class Validator {
    private static final String EMPTY_LIST = "[]";
    private static final String EMPTY_STRING = "\"\"";
    private static final int MAX_STRING_LENGTH = 4000;

    public static void notHugeString(Object value, String name) {
        boolean flag;
        boolean bl = flag = value instanceof String && Objects.toString(value, "").length() >= 4000;
        if (flag) {
            throw new JbpmException(name + " exceeds max length (" + 4000 + ")");
        }
    }

    public static void notEmptyValue(String value, String message) {
        if (StringUtils.isBlank((String)value) || EMPTY_STRING.equals(value)) {
            throw new JbpmException(message);
        }
    }

    public static void notType(String name, Object value, Class<?> ... notSupportedTypes) {
        if (value == null) {
            return;
        }
        if (notSupportedTypes == null || notSupportedTypes.length < 1 || notSupportedTypes[0] == null) {
            return;
        }
        for (Class<?> b : notSupportedTypes) {
            if (!b.isInstance(value)) continue;
            throw new JbpmException("Variable " + name + " uses unsupported data type - " + value.getClass().getName());
        }
    }

    public static void notEmptyList(String initialValue, Datatype datatype, String message) {
        if (datatype == Datatype.LIST && StringUtils.isBlank((String)initialValue) || EMPTY_LIST.equals(StringUtils.trim((String)initialValue))) {
            throw new JbpmException(message);
        }
    }
}

