/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.util;

import com.tandbergtv.workflow.core.Datatype;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.jbpm.JbpmException;

public class VariableValidator {
    public static final String EMPTY_STRING = "\"\"";
    private static final String EMPTY_LIST = "[]";
    private static final int MAX_STRING_LENGTH = 4000;

    public static void notHugeString(Object value, String name) {
        boolean flag;
        boolean bl = flag = value instanceof String && Objects.toString(value, "").length() >= 4000;
        if (flag) {
            throw new JbpmException(name + " exceeds max length (" + 4000 + ")");
        }
    }

    public static void notEmptyValue(String value, String message) {
        if (StringUtils.isBlank((String)value)) {
            throw new JbpmException(message);
        }
    }

    public static void notEmptyString(String value, String message) {
        if (value != null && value.length() == 0) {
            throw new JbpmException(message);
        }
    }

    public static void notType(String name, Object value, Class<?> ... notSupportedTypes) {
        if (value == null) {
            return;
        }
        if (notSupportedTypes == null || notSupportedTypes.length < 1 || notSupportedTypes[0] == null) {
            return;
        }
        for (Class<?> b : notSupportedTypes) {
            if (!b.isInstance(value)) continue;
            throw new JbpmException("Variable " + name + " uses unsupported data type - " + value.getClass().getName());
        }
    }

    public static void notEmptyList(String initialValue, Datatype datatype, String message) {
        if (datatype == Datatype.LIST && StringUtils.isBlank((String)initialValue) || EMPTY_LIST.equals(StringUtils.trim((String)initialValue))) {
            throw new JbpmException(message);
        }
    }

    public static void notEmptyElement(int index, Object value, String listName) {
        if (value == null) {
            throw new IllegalArgumentException("List " + listName + " item at index " + index + " is null");
        }
        if (value.toString().length() == 0) {
            throw new IllegalArgumentException("List " + listName + " item at index " + index + " is empty");
        }
    }

    public static void notOutRange(int index, List<?> list, String listName) {
        VariableValidator.notNull(list, "List " + listName + " cannot be null");
        if (list.isEmpty()) {
            throw new IndexOutOfBoundsException("Invalid index " + index + " for List Variable: " + listName + ", it's empty.");
        }
        if (index < 0 || index >= list.size()) {
            throw new IndexOutOfBoundsException("Invalid index " + index + " for List Variable:" + listName + ", valid range is [0-" + (list.size() - 1) + "]");
        }
    }

    public static void noEmptyElement(List<?> lists, String listName) {
        if (lists == null) {
            return;
        }
        for (int i = 0; i < lists.size(); ++i) {
            VariableValidator.notEmptyElement(i, lists.get(i), listName);
        }
    }

    public static void notNull(Object value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notBrokenListExpression(String expression) {
        if (expression.contains("[") && !expression.endsWith("]")) {
            throw new IllegalArgumentException("Invalid List expression: " + expression);
        }
        if (expression.endsWith("]") && !expression.contains("[")) {
            throw new IllegalArgumentException("Invalid List expression: " + expression);
        }
    }
}

