/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.shard.ShardId;

public class SnapshotsInProgress
extends AbstractDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "snapshots";
    public static final SnapshotsInProgress PROTO = new SnapshotsInProgress(new Entry[0]);
    private final List<Entry> entries;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotsInProgress that = (SnapshotsInProgress)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public static boolean completed(Collection<ShardSnapshotStatus> shards) {
        for (ShardSnapshotStatus status : shards) {
            if (status.state().completed()) continue;
            return false;
        }
        return true;
    }

    public SnapshotsInProgress(List<Entry> entries) {
        this.entries = entries;
    }

    public SnapshotsInProgress(Entry ... entries) {
        this.entries = Arrays.asList(entries);
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public Entry snapshot(SnapshotId snapshotId) {
        for (Entry entry : this.entries) {
            if (!snapshotId.equals(entry.snapshotId())) continue;
            return entry;
        }
        return null;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public SnapshotsInProgress readFrom(StreamInput in) throws IOException {
        Entry[] entries = new Entry[in.readVInt()];
        for (int i = 0; i < entries.length; ++i) {
            SnapshotId snapshotId = SnapshotId.readSnapshotId(in);
            boolean includeGlobalState = in.readBoolean();
            State state = State.fromValue(in.readByte());
            int indices = in.readVInt();
            ArrayList<String> indexBuilder = new ArrayList<String>();
            for (int j = 0; j < indices; ++j) {
                indexBuilder.add(in.readString());
            }
            long startTime = in.readLong();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            int shards = in.readVInt();
            for (int j = 0; j < shards; ++j) {
                ShardId shardId = ShardId.readShardId(in);
                String nodeId = in.readOptionalString();
                State shardState = State.fromValue(in.readByte());
                builder.put((Object)shardId, (Object)new ShardSnapshotStatus(nodeId, shardState));
            }
            entries[i] = new Entry(snapshotId, includeGlobalState, state, Collections.unmodifiableList(indexBuilder), startTime, (ImmutableMap<ShardId, ShardSnapshotStatus>)builder.build());
        }
        return new SnapshotsInProgress(entries);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.entries.size());
        for (Entry entry : this.entries) {
            entry.snapshotId().writeTo(out);
            out.writeBoolean(entry.includeGlobalState());
            out.writeByte(entry.state().value());
            out.writeVInt(entry.indices().size());
            for (String index : entry.indices()) {
                out.writeString(index);
            }
            out.writeLong(entry.startTime());
            out.writeVInt(entry.shards().size());
            for (Map.Entry shardEntry : entry.shards().entrySet()) {
                ((ShardId)shardEntry.getKey()).writeTo(out);
                out.writeOptionalString(((ShardSnapshotStatus)shardEntry.getValue()).nodeId());
                out.writeByte(((ShardSnapshotStatus)shardEntry.getValue()).state().value());
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Fields.SNAPSHOTS);
        for (Entry entry : this.entries) {
            this.toXContent(entry, builder, params);
        }
        builder.endArray();
        return builder;
    }

    public void toXContent(Entry entry, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Fields.REPOSITORY, entry.snapshotId().getRepository());
        builder.field(Fields.SNAPSHOT, entry.snapshotId().getSnapshot());
        builder.field(Fields.INCLUDE_GLOBAL_STATE, entry.includeGlobalState());
        builder.field(Fields.STATE, (Object)entry.state());
        builder.startArray(Fields.INDICES);
        for (String index : entry.indices()) {
            builder.value(index);
        }
        builder.endArray();
        builder.timeValueField(Fields.START_TIME_MILLIS, Fields.START_TIME, entry.startTime());
        builder.startArray(Fields.SHARDS);
        for (Map.Entry shardEntry : entry.shards.entrySet()) {
            ShardId shardId = (ShardId)shardEntry.getKey();
            ShardSnapshotStatus status = (ShardSnapshotStatus)shardEntry.getValue();
            builder.startObject();
            builder.field(Fields.INDEX, shardId.getIndex());
            builder.field(Fields.SHARD, shardId.getId());
            builder.field(Fields.STATE, (Object)status.state());
            builder.field(Fields.NODE, status.nodeId());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
    }

    static final class Fields {
        static final XContentBuilderString REPOSITORY = new XContentBuilderString("repository");
        static final XContentBuilderString SNAPSHOTS = new XContentBuilderString("snapshots");
        static final XContentBuilderString SNAPSHOT = new XContentBuilderString("snapshot");
        static final XContentBuilderString INCLUDE_GLOBAL_STATE = new XContentBuilderString("include_global_state");
        static final XContentBuilderString STATE = new XContentBuilderString("state");
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");
        static final XContentBuilderString START_TIME_MILLIS = new XContentBuilderString("start_time_millis");
        static final XContentBuilderString START_TIME = new XContentBuilderString("start_time");
        static final XContentBuilderString SHARDS = new XContentBuilderString("shards");
        static final XContentBuilderString INDEX = new XContentBuilderString("index");
        static final XContentBuilderString SHARD = new XContentBuilderString("shard");
        static final XContentBuilderString NODE = new XContentBuilderString("node");

        Fields() {
        }
    }

    public static enum State {
        INIT(0, false, false),
        STARTED(1, false, false),
        SUCCESS(2, true, false),
        FAILED(3, true, true),
        ABORTED(4, false, true),
        MISSING(5, true, true),
        WAITING(6, false, false);

        private byte value;
        private boolean completed;
        private boolean failed;

        private State(byte value, boolean completed, boolean failed) {
            this.value = value;
            this.completed = completed;
            this.failed = failed;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this.completed;
        }

        public boolean failed() {
            return this.failed;
        }

        public static State fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 1: {
                    return STARTED;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
                case 5: {
                    return MISSING;
                }
                case 6: {
                    return WAITING;
                }
            }
            throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
        }
    }

    public static class ShardSnapshotStatus {
        private State state;
        private String nodeId;
        private String reason;

        private ShardSnapshotStatus() {
        }

        public ShardSnapshotStatus(String nodeId) {
            this(nodeId, State.INIT);
        }

        public ShardSnapshotStatus(String nodeId, State state) {
            this(nodeId, state, null);
        }

        public ShardSnapshotStatus(String nodeId, State state, String reason) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
        }

        public State state() {
            return this.state;
        }

        public String nodeId() {
            return this.nodeId;
        }

        public String reason() {
            return this.reason;
        }

        public static ShardSnapshotStatus readShardSnapshotStatus(StreamInput in) throws IOException {
            ShardSnapshotStatus shardSnapshotStatus = new ShardSnapshotStatus();
            shardSnapshotStatus.readFrom(in);
            return shardSnapshotStatus;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.nodeId = in.readOptionalString();
            this.state = State.fromValue(in.readByte());
            this.reason = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            out.writeOptionalString(this.reason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardSnapshotStatus status = (ShardSnapshotStatus)o;
            if (this.nodeId != null ? !this.nodeId.equals(status.nodeId) : status.nodeId != null) {
                return false;
            }
            if (this.reason != null ? !this.reason.equals(status.reason) : status.reason != null) {
                return false;
            }
            return this.state == status.state;
        }

        public int hashCode() {
            int result = this.state != null ? this.state.hashCode() : 0;
            result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            return result;
        }
    }

    public static class Entry {
        private final State state;
        private final SnapshotId snapshotId;
        private final boolean includeGlobalState;
        private final ImmutableMap<ShardId, ShardSnapshotStatus> shards;
        private final List<String> indices;
        private final ImmutableMap<String, List<ShardId>> waitingIndices;
        private final long startTime;

        public Entry(SnapshotId snapshotId, boolean includeGlobalState, State state, List<String> indices, long startTime, ImmutableMap<ShardId, ShardSnapshotStatus> shards) {
            this.state = state;
            this.snapshotId = snapshotId;
            this.includeGlobalState = includeGlobalState;
            this.indices = indices;
            this.startTime = startTime;
            if (shards == null) {
                this.shards = ImmutableMap.of();
                this.waitingIndices = ImmutableMap.of();
            } else {
                this.shards = shards;
                this.waitingIndices = this.findWaitingIndices(shards);
            }
        }

        public Entry(Entry entry, State state, ImmutableMap<ShardId, ShardSnapshotStatus> shards) {
            this(entry.snapshotId, entry.includeGlobalState, state, entry.indices, entry.startTime, shards);
        }

        public Entry(Entry entry, ImmutableMap<ShardId, ShardSnapshotStatus> shards) {
            this(entry, entry.state, shards);
        }

        public SnapshotId snapshotId() {
            return this.snapshotId;
        }

        public ImmutableMap<ShardId, ShardSnapshotStatus> shards() {
            return this.shards;
        }

        public State state() {
            return this.state;
        }

        public List<String> indices() {
            return this.indices;
        }

        public ImmutableMap<String, List<ShardId>> waitingIndices() {
            return this.waitingIndices;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public long startTime() {
            return this.startTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.includeGlobalState != entry.includeGlobalState) {
                return false;
            }
            if (this.startTime != entry.startTime) {
                return false;
            }
            if (!this.indices.equals(entry.indices)) {
                return false;
            }
            if (!this.shards.equals(entry.shards)) {
                return false;
            }
            if (!this.snapshotId.equals(entry.snapshotId)) {
                return false;
            }
            if (this.state != entry.state) {
                return false;
            }
            return this.waitingIndices.equals(entry.waitingIndices);
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + this.snapshotId.hashCode();
            result = 31 * result + (this.includeGlobalState ? 1 : 0);
            result = 31 * result + this.shards.hashCode();
            result = 31 * result + this.indices.hashCode();
            result = 31 * result + this.waitingIndices.hashCode();
            result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
            return result;
        }

        private ImmutableMap<String, List<ShardId>> findWaitingIndices(ImmutableMap<ShardId, ShardSnapshotStatus> shards) {
            HashMap waitingIndicesMap = Maps.newHashMap();
            for (Map.Entry entry : shards.entrySet()) {
                if (((ShardSnapshotStatus)entry.getValue()).state() != State.WAITING) continue;
                ArrayList waitingShards = (ArrayList)waitingIndicesMap.get(((ShardId)entry.getKey()).getIndex());
                if (waitingShards == null) {
                    waitingShards = new ArrayList();
                    waitingIndicesMap.put(((ShardId)entry.getKey()).getIndex(), waitingShards);
                }
                waitingShards.add(entry.getKey());
            }
            if (!waitingIndicesMap.isEmpty()) {
                ImmutableMap.Builder waitingIndicesBuilder = ImmutableMap.builder();
                for (Map.Entry entry : waitingIndicesMap.entrySet()) {
                    waitingIndicesBuilder.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
                }
                return waitingIndicesBuilder.build();
            }
            return ImmutableMap.of();
        }
    }
}

