/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntroSorter;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.PriorityComparator;
import org.elasticsearch.node.settings.NodeSettingsService;

public class BalancedShardsAllocator
extends AbstractComponent
implements ShardsAllocator {
    public static final String SETTING_THRESHOLD = "cluster.routing.allocation.balance.threshold";
    public static final String SETTING_INDEX_BALANCE_FACTOR = "cluster.routing.allocation.balance.index";
    public static final String SETTING_SHARD_BALANCE_FACTOR = "cluster.routing.allocation.balance.shard";
    private static final float DEFAULT_INDEX_BALANCE_FACTOR = 0.55f;
    private static final float DEFAULT_SHARD_BALANCE_FACTOR = 0.45f;
    private volatile WeightFunction weightFunction = new WeightFunction(0.55f, 0.45f);
    private volatile float threshold = 1.0f;

    public BalancedShardsAllocator(Settings settings) {
        this(settings, new NodeSettingsService(settings));
    }

    @Inject
    public BalancedShardsAllocator(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        ApplySettings applySettings = new ApplySettings();
        applySettings.onRefreshSettings(settings);
        nodeSettingsService.addListener(applySettings);
    }

    @Override
    public void applyStartedShards(StartedRerouteAllocation allocation) {
    }

    @Override
    public void applyFailedShards(FailedRerouteAllocation allocation) {
    }

    @Override
    public boolean allocateUnassigned(RoutingAllocation allocation) {
        Balancer balancer = new Balancer(this.logger, allocation, this.weightFunction, this.threshold);
        return balancer.allocateUnassigned();
    }

    @Override
    public boolean rebalance(RoutingAllocation allocation) {
        Balancer balancer = new Balancer(this.logger, allocation, this.weightFunction, this.threshold);
        return balancer.balance();
    }

    @Override
    public boolean moveShards(RoutingAllocation allocation) {
        Balancer balancer = new Balancer(this.logger, allocation, this.weightFunction, this.threshold);
        return balancer.moveShards();
    }

    public float getThreshold() {
        return this.threshold;
    }

    public float getIndexBalance() {
        return this.weightFunction.indexBalance;
    }

    public float getShardBalance() {
        return this.weightFunction.shardBalance;
    }

    static final class NodeSorter
    extends IntroSorter {
        final ModelNode[] modelNodes;
        final float[] weights;
        private final WeightFunction function;
        private String index;
        private final Balancer balancer;
        private float pivotWeight;

        public NodeSorter(ModelNode[] modelNodes, WeightFunction function, Balancer balancer) {
            this.function = function;
            this.balancer = balancer;
            this.modelNodes = modelNodes;
            this.weights = new float[modelNodes.length];
        }

        public void reset(String index, int from, int to) {
            this.index = index;
            for (int i = from; i < to; ++i) {
                this.weights[i] = this.weight(this.modelNodes[i]);
            }
            this.sort(from, to);
        }

        public void reset(String index) {
            this.reset(index, 0, this.modelNodes.length);
        }

        public float weight(ModelNode node) {
            return this.function.weight(this.balancer, node, this.index);
        }

        protected void swap(int i, int j) {
            ModelNode tmpNode = this.modelNodes[i];
            this.modelNodes[i] = this.modelNodes[j];
            this.modelNodes[j] = tmpNode;
            float tmpWeight = this.weights[i];
            this.weights[i] = this.weights[j];
            this.weights[j] = tmpWeight;
        }

        protected int compare(int i, int j) {
            return Float.compare(this.weights[i], this.weights[j]);
        }

        protected void setPivot(int i) {
            this.pivotWeight = this.weights[i];
        }

        protected int comparePivot(int j) {
            return Float.compare(this.pivotWeight, this.weights[j]);
        }

        public float delta() {
            return this.weights[this.weights.length - 1] - this.weights[0];
        }
    }

    static final class ModelIndex {
        private final String id;
        private final Map<ShardRouting, Decision> shards = new HashMap<ShardRouting, Decision>();
        private int highestPrimary = -1;

        public ModelIndex(String id) {
            this.id = id;
        }

        public int highestPrimary() {
            if (this.highestPrimary == -1) {
                int maxId = -1;
                for (ShardRouting shard : this.shards.keySet()) {
                    if (!shard.primary()) continue;
                    maxId = Math.max(maxId, shard.id());
                }
                this.highestPrimary = maxId;
                return this.highestPrimary;
            }
            return this.highestPrimary;
        }

        public String getIndexId() {
            return this.id;
        }

        public int numShards() {
            return this.shards.size();
        }

        public Collection<ShardRouting> getAllShards() {
            return this.shards.keySet();
        }

        public Decision removeShard(ShardRouting shard) {
            this.highestPrimary = -1;
            return this.shards.remove(shard);
        }

        public void addShard(ShardRouting shard, Decision decision) {
            this.highestPrimary = -1;
            assert (decision != null);
            assert (!this.shards.containsKey(shard)) : "Shard already allocated on current node: " + this.shards.get(shard) + " " + shard;
            this.shards.put(shard, decision);
        }

        public boolean containsShard(ShardRouting shard) {
            return this.shards.containsKey(shard);
        }
    }

    static class ModelNode
    implements Iterable<ModelIndex> {
        private final String id;
        private final Map<String, ModelIndex> indices = new HashMap<String, ModelIndex>();
        private int numShards = 0;
        private RoutingNode routingNode;

        public ModelNode(String id) {
            this.id = id;
        }

        public ModelIndex getIndex(String indexId) {
            return this.indices.get(indexId);
        }

        public String getNodeId() {
            return this.id;
        }

        public RoutingNode getRoutingNode(RoutingNodes routingNodes) {
            if (this.routingNode == null) {
                this.routingNode = routingNodes.node(this.id);
            }
            return this.routingNode;
        }

        public int numShards() {
            return this.numShards;
        }

        public int numShards(String idx) {
            ModelIndex index = this.indices.get(idx);
            return index == null ? 0 : index.numShards();
        }

        public int highestPrimary(String index) {
            ModelIndex idx = this.indices.get(index);
            if (idx != null) {
                return idx.highestPrimary();
            }
            return -1;
        }

        public void addShard(ShardRouting shard, Decision decision) {
            ModelIndex index = this.indices.get(shard.index());
            if (index == null) {
                index = new ModelIndex(shard.index());
                this.indices.put(index.getIndexId(), index);
            }
            index.addShard(shard, decision);
            ++this.numShards;
        }

        public Decision removeShard(ShardRouting shard) {
            ModelIndex index = this.indices.get(shard.index());
            Decision removed = null;
            if (index != null && (removed = index.removeShard(shard)) != null && index.numShards() == 0) {
                this.indices.remove(shard.index());
            }
            --this.numShards;
            return removed;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Node(").append(this.id).append(")");
            return sb.toString();
        }

        @Override
        public Iterator<ModelIndex> iterator() {
            return this.indices.values().iterator();
        }

        public boolean containsShard(ShardRouting shard) {
            ModelIndex index = this.getIndex(shard.getIndex());
            return index == null ? false : index.containsShard(shard);
        }
    }

    public static class Balancer {
        private final ESLogger logger;
        private final Map<String, ModelNode> nodes = new HashMap<String, ModelNode>();
        private final HashSet<String> indices = new HashSet();
        private final RoutingAllocation allocation;
        private final RoutingNodes routingNodes;
        private final WeightFunction weight;
        private final float threshold;
        private final MetaData metaData;
        private final float avgShardsPerNode;
        private final Predicate<ShardRouting> assignedFilter = new Predicate<ShardRouting>(){

            public boolean apply(ShardRouting input) {
                return input.assignedToNode();
            }
        };

        public Balancer(ESLogger logger, RoutingAllocation allocation, WeightFunction weight, float threshold) {
            this.logger = logger;
            this.allocation = allocation;
            this.weight = weight;
            this.threshold = threshold;
            this.routingNodes = allocation.routingNodes();
            for (RoutingNode node : this.routingNodes) {
                this.nodes.put(node.nodeId(), new ModelNode(node.nodeId()));
            }
            this.metaData = this.routingNodes.metaData();
            this.avgShardsPerNode = (float)this.metaData.totalNumberOfShards() / (float)this.nodes.size();
        }

        private ModelNode[] nodesArray() {
            return this.nodes.values().toArray(new ModelNode[this.nodes.size()]);
        }

        public float avgShardsPerNode(String index) {
            return (float)this.metaData.index(index).getTotalNumberOfShards() / (float)this.nodes.size();
        }

        public float avgShardsPerNode() {
            return this.avgShardsPerNode;
        }

        private NodeSorter newNodeSorter() {
            return new NodeSorter(this.nodesArray(), this.weight, this);
        }

        private boolean initialize(RoutingNodes routing, RoutingNodes.UnassignedShards unassigned) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Start distributing Shards", new Object[0]);
            }
            this.indices.addAll(this.allocation.routingTable().indicesRouting().keySet());
            this.buildModelFromAssigned(routing.shards(this.assignedFilter));
            return this.allocateUnassigned(unassigned);
        }

        private static float absDelta(float lower, float higher) {
            assert (higher >= lower) : higher + " lt " + lower + " but was expected to be gte";
            return Math.abs(higher - lower);
        }

        private static boolean lessThan(float delta, float threshold) {
            return delta <= threshold + 0.001f;
        }

        final boolean allocateUnassigned() {
            return this.balance(true);
        }

        public boolean balance() {
            return this.balance(false);
        }

        private boolean balance(boolean onlyAssign) {
            if (this.nodes.isEmpty()) {
                return false;
            }
            if (this.logger.isTraceEnabled()) {
                if (onlyAssign) {
                    this.logger.trace("Start balancing cluster", new Object[0]);
                } else {
                    this.logger.trace("Start assigning unassigned shards", new Object[0]);
                }
            }
            RoutingNodes.UnassignedShards unassigned = this.routingNodes.unassigned();
            boolean changed = this.initialize(this.routingNodes, unassigned);
            if (!onlyAssign && !changed && this.allocation.deciders().canRebalance(this.allocation).type() == Decision.Type.YES) {
                NodeSorter sorter = this.newNodeSorter();
                if (this.nodes.size() > 1) {
                    AllocationDeciders deciders = this.allocation.deciders();
                    ModelNode[] modelNodes = sorter.modelNodes;
                    float[] weights = sorter.weights;
                    block0: for (String index : this.buildWeightOrderedIndices(sorter)) {
                        IndexMetaData indexMetaData = this.metaData.index(index);
                        int relevantNodes = 0;
                        for (int i = 0; i < modelNodes.length; ++i) {
                            ModelNode modelNode = modelNodes[i];
                            if (modelNode.getIndex(index) == null && deciders.canAllocate(indexMetaData, modelNode.getRoutingNode(this.routingNodes), this.allocation).type() == Decision.Type.NO) continue;
                            modelNodes[i] = modelNodes[relevantNodes];
                            modelNodes[relevantNodes] = modelNode;
                            ++relevantNodes;
                        }
                        if (relevantNodes < 2) continue;
                        sorter.reset(index, 0, relevantNodes);
                        int lowIdx = 0;
                        int highIdx = relevantNodes - 1;
                        while (true) {
                            ModelNode minNode = modelNodes[lowIdx];
                            ModelNode maxNode = modelNodes[highIdx];
                            if (maxNode.numShards(index) > 0) {
                                float delta = Balancer.absDelta(weights[lowIdx], weights[highIdx]);
                                if (Balancer.lessThan(delta, this.threshold)) {
                                    if (lowIdx <= 0 || highIdx - 1 <= 0 || !(Balancer.absDelta(weights[0], weights[highIdx - 1]) > this.threshold)) {
                                        if (!this.logger.isTraceEnabled()) continue block0;
                                        this.logger.trace("Stop balancing index [{}]  min_node [{}] weight: [{}]  max_node [{}] weight: [{}]  delta: [{}]", index, maxNode.getNodeId(), Float.valueOf(weights[highIdx]), minNode.getNodeId(), Float.valueOf(weights[lowIdx]), Float.valueOf(delta));
                                        continue block0;
                                    }
                                } else {
                                    if (this.logger.isTraceEnabled()) {
                                        this.logger.trace("Balancing from node [{}] weight: [{}] to node [{}] weight: [{}]  delta: [{}]", maxNode.getNodeId(), Float.valueOf(weights[highIdx]), minNode.getNodeId(), Float.valueOf(weights[lowIdx]), Float.valueOf(delta));
                                    }
                                    if (this.tryRelocateShard(minNode, maxNode, index, delta)) {
                                        weights[lowIdx] = sorter.weight(modelNodes[lowIdx]);
                                        weights[highIdx] = sorter.weight(modelNodes[highIdx]);
                                        sorter.sort(0, relevantNodes);
                                        lowIdx = 0;
                                        highIdx = relevantNodes - 1;
                                        changed = true;
                                        continue;
                                    }
                                }
                            }
                            if (lowIdx < highIdx - 1) {
                                ++lowIdx;
                                continue;
                            }
                            if (lowIdx <= 0) continue block0;
                            lowIdx = 0;
                            --highIdx;
                        }
                    }
                }
            }
            return changed;
        }

        private String[] buildWeightOrderedIndices(NodeSorter sorter) {
            final String[] indices = this.indices.toArray(new String[this.indices.size()]);
            final float[] deltas = new float[indices.length];
            for (int i = 0; i < deltas.length; ++i) {
                sorter.reset(indices[i]);
                deltas[i] = sorter.delta();
            }
            new IntroSorter(){
                float pivotWeight;

                protected void swap(int i, int j) {
                    String tmpIdx = indices[i];
                    indices[i] = indices[j];
                    indices[j] = tmpIdx;
                    float tmpDelta = deltas[i];
                    deltas[i] = deltas[j];
                    deltas[j] = tmpDelta;
                }

                protected int compare(int i, int j) {
                    return Float.compare(deltas[j], deltas[i]);
                }

                protected void setPivot(int i) {
                    this.pivotWeight = deltas[i];
                }

                protected int comparePivot(int j) {
                    return Float.compare(deltas[j], this.pivotWeight);
                }
            }.sort(0, deltas.length);
            return indices;
        }

        public boolean moveShards() {
            if (this.nodes.isEmpty()) {
                return false;
            }
            ArrayList<ShardRouting> shards = new ArrayList<ShardRouting>();
            int index = 0;
            boolean found = true;
            while (found) {
                found = false;
                for (RoutingNode routingNode : this.routingNodes) {
                    if (index >= routingNode.size()) continue;
                    found = true;
                    ShardRouting shardRouting = routingNode.get(index);
                    if (!shardRouting.started()) continue;
                    shards.add(shardRouting);
                }
                ++index;
            }
            if (shards.isEmpty()) {
                return false;
            }
            RoutingNodes.UnassignedShards unassigned = this.routingNodes.unassigned();
            boolean changed = this.initialize(this.routingNodes, unassigned);
            if (!changed) {
                NodeSorter sorter = this.newNodeSorter();
                ModelNode[] modelNodes = sorter.modelNodes;
                for (ShardRouting shardRouting : shards) {
                    ModelNode sourceNode = this.nodes.get(shardRouting.currentNodeId());
                    assert (sourceNode != null && sourceNode.containsShard(shardRouting));
                    RoutingNode routingNode = sourceNode.getRoutingNode(this.routingNodes);
                    Decision decision = this.allocation.deciders().canRemain(shardRouting, routingNode, this.allocation);
                    if (decision.type() != Decision.Type.NO) continue;
                    this.logger.debug("[{}][{}] allocated on [{}], but can no longer be allocated on it, moving...", shardRouting.index(), shardRouting.id(), routingNode.node());
                    sorter.reset(shardRouting.getIndex());
                    boolean moved = false;
                    for (ModelNode currentNode : modelNodes) {
                        if (currentNode == sourceNode) continue;
                        RoutingNode target = currentNode.getRoutingNode(this.routingNodes);
                        Decision allocationDecision = this.allocation.deciders().canAllocate(shardRouting, target, this.allocation);
                        if (allocationDecision.type() != Decision.Type.YES) continue;
                        Decision sourceDecision = sourceNode.removeShard(shardRouting);
                        ShardRouting targetRelocatingShard = this.routingNodes.relocate(shardRouting, target.nodeId(), this.allocation.clusterInfo().getShardSize(shardRouting, -1L));
                        sourceNode.addShard(shardRouting, sourceDecision);
                        currentNode.addShard(targetRelocatingShard, allocationDecision);
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("Moved shard [{}] to node [{}]", shardRouting, routingNode.node());
                        }
                        moved = true;
                        changed = true;
                        break;
                    }
                    if (moved) continue;
                    this.logger.debug("[{}][{}] can't move", shardRouting.index(), shardRouting.id());
                }
            }
            return changed;
        }

        private void buildModelFromAssigned(Iterable<ShardRouting> shards) {
            for (ShardRouting shard : shards) {
                assert (shard.assignedToNode());
                if (shard.state() == ShardRoutingState.RELOCATING) continue;
                ModelNode node = this.nodes.get(shard.currentNodeId());
                assert (node != null);
                node.addShard(shard, Decision.single(Decision.Type.YES, "Already allocated on node", node.getNodeId(), new Object[0]));
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("Assigned shard [{}] to node [{}]", shard, node.getNodeId());
            }
        }

        private boolean allocateUnassigned(RoutingNodes.UnassignedShards unassigned) {
            assert (!this.nodes.isEmpty());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Start allocating unassigned shards", new Object[0]);
            }
            if (unassigned.isEmpty()) {
                return false;
            }
            boolean changed = false;
            AllocationDeciders deciders = this.allocation.deciders();
            final PriorityComparator secondaryComparator = PriorityComparator.getAllocationComparator(this.allocation);
            Comparator<ShardRouting> comparator = new Comparator<ShardRouting>(){

                @Override
                public int compare(ShardRouting o1, ShardRouting o2) {
                    if (o1.primary() ^ o2.primary()) {
                        return o1.primary() ? -1 : (o2.primary() ? 1 : 0);
                    }
                    int indexCmp = o1.index().compareTo(o2.index());
                    if (indexCmp == 0) {
                        return o1.getId() - o2.getId();
                    }
                    int secondary = secondaryComparator.compare(o1, o2);
                    return secondary == 0 ? indexCmp : secondary;
                }
            };
            Object[] primary = unassigned.drain();
            Object[] secondary = new ShardRouting[primary.length];
            int secondaryLength = 0;
            int primaryLength = primary.length;
            ArrayUtil.timSort((Object[])primary, (Comparator)comparator);
            Set throttledNodes = Collections.newSetFromMap(new IdentityHashMap());
            do {
                for (int i = 0; i < primaryLength; ++i) {
                    Object shard = primary[i];
                    if (!((ShardRouting)shard).primary()) {
                        boolean drop;
                        boolean bl = drop = deciders.canAllocate((ShardRouting)shard, this.allocation).type() == Decision.Type.NO;
                        if (drop) {
                            unassigned.ignoreShard((ShardRouting)shard);
                            while (i < primaryLength - 1 && comparator.compare((ShardRouting)primary[i], (ShardRouting)primary[i + 1]) == 0) {
                                unassigned.ignoreShard((ShardRouting)primary[++i]);
                            }
                            continue;
                        }
                        while (i < primaryLength - 1 && comparator.compare((ShardRouting)primary[i], (ShardRouting)primary[i + 1]) == 0) {
                            secondary[secondaryLength++] = primary[++i];
                        }
                    }
                    assert (!((ShardRouting)shard).assignedToNode()) : shard;
                    float minWeight = Float.POSITIVE_INFINITY;
                    ModelNode minNode = null;
                    Decision decision = null;
                    if (throttledNodes.size() < this.nodes.size()) {
                        for (ModelNode node : this.nodes.values()) {
                            Decision currentDecision;
                            float currentWeight;
                            if (throttledNodes.contains(node) || node.containsShard((ShardRouting)shard) || !((currentWeight = this.weight.weightShardAdded(this, node, ((ShardRouting)shard).index())) <= minWeight) || (currentDecision = deciders.canAllocate((ShardRouting)shard, node.getRoutingNode(this.routingNodes), this.allocation)).type() != Decision.Type.YES && currentDecision.type() != Decision.Type.THROTTLE) continue;
                            if (currentWeight == minWeight) {
                                if (currentDecision.type() == decision.type()) {
                                    int repId = ((ShardRouting)shard).id();
                                    int nodeHigh = node.highestPrimary(((ShardRouting)shard).index());
                                    int minNodeHigh = minNode.highestPrimary(((ShardRouting)shard).index());
                                    if (!((nodeHigh > repId && minNodeHigh > repId || nodeHigh < repId && minNodeHigh < repId) && nodeHigh < minNodeHigh) && (nodeHigh <= minNodeHigh || nodeHigh <= repId || minNodeHigh >= repId)) continue;
                                    minNode = node;
                                    minWeight = currentWeight;
                                    decision = currentDecision;
                                } else if (currentDecision.type() != Decision.Type.YES) continue;
                            }
                            minNode = node;
                            minWeight = currentWeight;
                            decision = currentDecision;
                        }
                    }
                    assert (decision != null && minNode != null || decision == null && minNode == null);
                    if (minNode != null) {
                        minNode.addShard((ShardRouting)shard, decision);
                        if (decision.type() == Decision.Type.YES) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("Assigned shard [{}] to [{}]", shard, minNode.getNodeId());
                            }
                            this.routingNodes.initialize((ShardRouting)shard, minNode.getNodeId(), this.allocation.clusterInfo().getShardSize((ShardRouting)shard, -1L));
                            changed = true;
                            continue;
                        }
                        RoutingNode node = minNode.getRoutingNode(this.routingNodes);
                        if (deciders.canAllocate(node, this.allocation).type() != Decision.Type.YES) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("Can not allocate on node [{}] remove from round decision [{}]", new Object[]{node, decision.type()});
                            }
                            throttledNodes.add(minNode);
                        }
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("No eligable node found to assign shard [{}] decision [{}]", new Object[]{shard, decision.type()});
                        }
                    } else if (this.logger.isTraceEnabled()) {
                        this.logger.trace("No Node found to assign shard [{}]", shard);
                    }
                    unassigned.ignoreShard((ShardRouting)shard);
                    if (((ShardRouting)shard).primary()) continue;
                    while (secondaryLength > 0 && comparator.compare((ShardRouting)shard, (ShardRouting)secondary[secondaryLength - 1]) == 0) {
                        unassigned.ignoreShard((ShardRouting)secondary[--secondaryLength]);
                    }
                }
                primaryLength = secondaryLength;
                Object[] tmp = primary;
                primary = secondary;
                secondary = tmp;
                secondaryLength = 0;
            } while (primaryLength > 0);
            return changed;
        }

        private boolean tryRelocateShard(ModelNode minNode, ModelNode maxNode, String idx, float minCost) {
            ModelIndex index = maxNode.getIndex(idx);
            Decision decision = null;
            if (index != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Try relocating shard for index index [{}] from node [{}] to node [{}]", idx, maxNode.getNodeId(), minNode.getNodeId());
                }
                ShardRouting candidate = null;
                AllocationDeciders deciders = this.allocation.deciders();
                for (ShardRouting shard : index.getAllShards()) {
                    float delta;
                    if (!shard.started()) continue;
                    Decision allocationDecision = deciders.canAllocate(shard, minNode.getRoutingNode(this.routingNodes), this.allocation);
                    Decision rebalanceDecision = deciders.canRebalance(shard, this.allocation);
                    if (allocationDecision.type() != Decision.Type.YES && allocationDecision.type() != Decision.Type.THROTTLE || rebalanceDecision.type() != Decision.Type.YES && rebalanceDecision.type() != Decision.Type.THROTTLE || !maxNode.containsShard(shard) || !((delta = this.weight.weightShardAdded(this, minNode, idx) - this.weight.weightShardRemoved(this, maxNode, idx)) < minCost) && (candidate == null || delta != minCost || candidate.id() <= shard.id())) continue;
                    minCost = delta;
                    candidate = shard;
                    decision = new Decision.Multi().add(allocationDecision).add(rebalanceDecision);
                }
                if (candidate != null) {
                    maxNode.removeShard(candidate);
                    minNode.addShard(candidate, decision);
                    if (decision.type() == Decision.Type.YES) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("Relocate shard [{}] from node [{}] to node [{}]", candidate, maxNode.getNodeId(), minNode.getNodeId());
                        }
                        if (candidate.started()) {
                            this.routingNodes.relocate(candidate, minNode.getNodeId(), this.allocation.clusterInfo().getShardSize(candidate, -1L));
                        } else {
                            this.routingNodes.initialize(candidate, minNode.getNodeId(), this.allocation.clusterInfo().getShardSize(candidate, -1L));
                        }
                        return true;
                    }
                }
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Couldn't find shard to relocate from node [{}] to node [{}] allocation decision [{}]", maxNode.getNodeId(), minNode.getNodeId(), decision == null ? "NO" : decision.type().name());
            }
            return false;
        }
    }

    public static class WeightFunction {
        private final float indexBalance;
        private final float shardBalance;
        private final float theta0;
        private final float theta1;

        public WeightFunction(float indexBalance, float shardBalance) {
            float sum = indexBalance + shardBalance;
            if (sum <= 0.0f) {
                throw new IllegalArgumentException("Balance factors must sum to a value > 0 but was: " + sum);
            }
            this.theta0 = shardBalance / sum;
            this.theta1 = indexBalance / sum;
            this.indexBalance = indexBalance;
            this.shardBalance = shardBalance;
        }

        public float weight(Balancer balancer, ModelNode node, String index) {
            return this.weight(balancer, node, index, 0);
        }

        public float weightShardAdded(Balancer balancer, ModelNode node, String index) {
            return this.weight(balancer, node, index, 1);
        }

        public float weightShardRemoved(Balancer balancer, ModelNode node, String index) {
            return this.weight(balancer, node, index, -1);
        }

        private float weight(Balancer balancer, ModelNode node, String index, int numAdditionalShards) {
            float weightShard = (float)(node.numShards() + numAdditionalShards) - balancer.avgShardsPerNode();
            float weightIndex = (float)(node.numShards(index) + numAdditionalShards) - balancer.avgShardsPerNode(index);
            return this.theta0 * weightShard + this.theta1 * weightIndex;
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            float indexBalance = settings.getAsFloat(BalancedShardsAllocator.SETTING_INDEX_BALANCE_FACTOR, Float.valueOf(BalancedShardsAllocator.this.weightFunction.indexBalance)).floatValue();
            float shardBalance = settings.getAsFloat(BalancedShardsAllocator.SETTING_SHARD_BALANCE_FACTOR, Float.valueOf(BalancedShardsAllocator.this.weightFunction.shardBalance)).floatValue();
            float threshold = settings.getAsFloat(BalancedShardsAllocator.SETTING_THRESHOLD, Float.valueOf(BalancedShardsAllocator.this.threshold)).floatValue();
            if (threshold <= 0.0f) {
                throw new IllegalArgumentException("threshold must be greater than 0.0f but was: " + threshold);
            }
            BalancedShardsAllocator.this.threshold = threshold;
            BalancedShardsAllocator.this.weightFunction = new WeightFunction(indexBalance, shardBalance);
        }
    }
}

