/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.BytesStream;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentGenerator;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class XContentBuilder
implements BytesStream,
Releasable {
    public static final DateTimeFormatter defaultDatePrinter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    protected static FieldCaseConversion globalFieldCaseConversion = FieldCaseConversion.NONE;
    private XContentGenerator generator;
    private final OutputStream bos;
    private FieldCaseConversion fieldCaseConversion = globalFieldCaseConversion;
    private StringBuilder cachedStringBuilder;
    private boolean humanReadable = false;

    public static void globalFieldCaseConversion(FieldCaseConversion globalFieldCaseConversion) {
        XContentBuilder.globalFieldCaseConversion = globalFieldCaseConversion;
    }

    public static XContentBuilder builder(XContent xContent) throws IOException {
        return new XContentBuilder(xContent, new BytesStreamOutput());
    }

    public static XContentBuilder builder(XContent xContent, String[] filters) throws IOException {
        return new XContentBuilder(xContent, new BytesStreamOutput(), filters);
    }

    public XContentBuilder(XContent xContent, OutputStream bos) throws IOException {
        this(xContent, bos, null);
    }

    public XContentBuilder(XContent xContent, OutputStream bos, String[] filters) throws IOException {
        this.bos = bos;
        this.generator = xContent.createGenerator(bos, filters);
    }

    public XContentBuilder fieldCaseConversion(FieldCaseConversion fieldCaseConversion) {
        this.fieldCaseConversion = fieldCaseConversion;
        return this;
    }

    public XContentType contentType() {
        return this.generator.contentType();
    }

    public XContentBuilder prettyPrint() {
        this.generator.usePrettyPrint();
        return this;
    }

    public XContentBuilder lfAtEnd() {
        this.generator.usePrintLineFeedAtEnd();
        return this;
    }

    public XContentBuilder humanReadable(boolean humanReadable) {
        this.humanReadable = humanReadable;
        return this;
    }

    public boolean humanReadable() {
        return this.humanReadable;
    }

    public XContentBuilder field(String name, ToXContent xContent) throws IOException {
        this.field(name);
        xContent.toXContent(this, ToXContent.EMPTY_PARAMS);
        return this;
    }

    public XContentBuilder field(String name, ToXContent xContent, ToXContent.Params params) throws IOException {
        this.field(name);
        xContent.toXContent(this, params);
        return this;
    }

    public XContentBuilder startObject(String name) throws IOException {
        this.field(name);
        this.startObject();
        return this;
    }

    public XContentBuilder startObject(String name, FieldCaseConversion conversion) throws IOException {
        this.field(name, conversion);
        this.startObject();
        return this;
    }

    public XContentBuilder startObject(XContentBuilderString name) throws IOException {
        this.field(name);
        this.startObject();
        return this;
    }

    public XContentBuilder startObject(XContentBuilderString name, FieldCaseConversion conversion) throws IOException {
        this.field(name, conversion);
        this.startObject();
        return this;
    }

    public XContentBuilder startObject() throws IOException {
        this.generator.writeStartObject();
        return this;
    }

    public XContentBuilder endObject() throws IOException {
        this.generator.writeEndObject();
        return this;
    }

    public XContentBuilder array(String name, String ... values) throws IOException {
        this.startArray(name);
        for (String value : values) {
            this.value(value);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder array(XContentBuilderString name, String ... values) throws IOException {
        this.startArray(name);
        for (String value : values) {
            this.value(value);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder array(String name, Object ... values) throws IOException {
        this.startArray(name);
        for (Object value : values) {
            this.value(value);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder array(XContentBuilderString name, Object ... values) throws IOException {
        this.startArray(name);
        for (Object value : values) {
            this.value(value);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder startArray(String name, FieldCaseConversion conversion) throws IOException {
        this.field(name, conversion);
        this.startArray();
        return this;
    }

    public XContentBuilder startArray(String name) throws IOException {
        this.field(name);
        this.startArray();
        return this;
    }

    public XContentBuilder startArray(XContentBuilderString name) throws IOException {
        this.field(name);
        this.startArray();
        return this;
    }

    public XContentBuilder startArray() throws IOException {
        this.generator.writeStartArray();
        return this;
    }

    public XContentBuilder endArray() throws IOException {
        this.generator.writeEndArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name) throws IOException {
        return this.field(name, this.fieldCaseConversion);
    }

    public XContentBuilder field(XContentBuilderString name, FieldCaseConversion conversion) throws IOException {
        if (conversion == FieldCaseConversion.UNDERSCORE) {
            this.generator.writeFieldName(name.underscore());
        } else if (conversion == FieldCaseConversion.CAMELCASE) {
            this.generator.writeFieldName(name.camelCase());
        } else {
            this.generator.writeFieldName(name.underscore());
        }
        return this;
    }

    public XContentBuilder field(String name) throws IOException {
        return this.field(name, this.fieldCaseConversion);
    }

    public XContentBuilder field(String name, FieldCaseConversion conversion) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("field name cannot be null");
        }
        if (conversion == FieldCaseConversion.UNDERSCORE) {
            if (this.cachedStringBuilder == null) {
                this.cachedStringBuilder = new StringBuilder();
            }
            name = Strings.toUnderscoreCase(name, this.cachedStringBuilder);
        } else if (conversion == FieldCaseConversion.CAMELCASE) {
            if (this.cachedStringBuilder == null) {
                this.cachedStringBuilder = new StringBuilder();
            }
            name = Strings.toCamelCase(name, this.cachedStringBuilder);
        }
        this.generator.writeFieldName(name);
        return this;
    }

    public XContentBuilder field(String name, char[] value, int offset, int length) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value, offset, length);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, char[] value, int offset, int length) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value, offset, length);
        }
        return this;
    }

    public XContentBuilder field(String name, String value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value);
        }
        return this;
    }

    public XContentBuilder field(String name, String value, FieldCaseConversion conversion) throws IOException {
        this.field(name, conversion);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, String value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, String value, FieldCaseConversion conversion) throws IOException {
        this.field(name, conversion);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value);
        }
        return this;
    }

    public XContentBuilder field(String name, Integer value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Integer value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public XContentBuilder field(String name, int value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, int value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Long value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Long value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public XContentBuilder field(String name, long value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, long value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Float value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value.floatValue());
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Float value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value.floatValue());
        }
        return this;
    }

    public XContentBuilder field(String name, float value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, float value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, Double value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Double value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public XContentBuilder field(String name, double value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, double value) throws IOException {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder field(String name, BigDecimal value) throws IOException {
        return this.field(name, value, value.scale(), RoundingMode.HALF_UP, true);
    }

    public XContentBuilder field(XContentBuilderString name, BigDecimal value) throws IOException {
        return this.field(name, value, value.scale(), RoundingMode.HALF_UP, true);
    }

    public XContentBuilder field(String name, BigDecimal value, int scale, RoundingMode rounding, boolean toDouble) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else if (toDouble) {
            try {
                this.generator.writeNumber(value.setScale(scale, rounding).doubleValue());
            }
            catch (ArithmeticException e) {
                this.generator.writeString(value.toEngineeringString());
            }
        } else {
            this.generator.writeString(value.toEngineeringString());
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, BigDecimal value, int scale, RoundingMode rounding, boolean toDouble) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else if (toDouble) {
            try {
                this.generator.writeNumber(value.setScale(scale, rounding).doubleValue());
            }
            catch (ArithmeticException e) {
                this.generator.writeString(value.toEngineeringString());
            }
        } else {
            this.generator.writeString(value.toEngineeringString());
        }
        return this;
    }

    public XContentBuilder field(String name, BytesRef value) throws IOException {
        this.field(name);
        this.generator.writeBinary(value.bytes, value.offset, value.length);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, BytesRef value) throws IOException {
        this.field(name);
        this.generator.writeBinary(value.bytes, value.offset, value.length);
        return this;
    }

    public XContentBuilder field(String name, BytesReference value) throws IOException {
        this.field(name);
        if (!value.hasArray()) {
            value = value.toBytesArray();
        }
        this.generator.writeBinary(value.array(), value.arrayOffset(), value.length());
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, BytesReference value) throws IOException {
        this.field(name);
        if (!value.hasArray()) {
            value = value.toBytesArray();
        }
        this.generator.writeBinary(value.array(), value.arrayOffset(), value.length());
        return this;
    }

    public XContentBuilder utf8Field(XContentBuilderString name, BytesRef value) throws IOException {
        this.field(name);
        this.generator.writeUTF8String(value.bytes, value.offset, value.length);
        return this;
    }

    public XContentBuilder utf8Field(String name, BytesRef value) throws IOException {
        this.field(name);
        this.generator.writeUTF8String(value.bytes, value.offset, value.length);
        return this;
    }

    public XContentBuilder field(String name, Text value) throws IOException {
        this.field(name);
        if (value.hasBytes() && value.bytes().hasArray()) {
            this.generator.writeUTF8String(value.bytes().array(), value.bytes().arrayOffset(), value.bytes().length());
            return this;
        }
        if (value.hasString()) {
            this.generator.writeString(value.string());
            return this;
        }
        BytesArray bytesArray = value.bytes().toBytesArray();
        this.generator.writeUTF8String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length());
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Text value) throws IOException {
        this.field(name);
        if (value.hasBytes() && value.bytes().hasArray()) {
            this.generator.writeUTF8String(value.bytes().array(), value.bytes().arrayOffset(), value.bytes().length());
            return this;
        }
        if (value.hasString()) {
            this.generator.writeString(value.string());
            return this;
        }
        BytesArray bytesArray = value.bytes().toBytesArray();
        this.generator.writeUTF8String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length());
        return this;
    }

    public XContentBuilder field(String name, byte[] value, int offset, int length) throws IOException {
        this.field(name);
        this.generator.writeBinary(value, offset, length);
        return this;
    }

    public XContentBuilder field(String name, Map<String, Object> value) throws IOException {
        this.field(name);
        this.value(value);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Map<String, Object> value) throws IOException {
        this.field(name);
        this.value(value);
        return this;
    }

    public XContentBuilder field(String name, Iterable<?> value) throws IOException {
        if (value instanceof Path) {
            this.field(name);
            this.value(value);
        } else {
            this.startArray(name);
            for (Object o : value) {
                this.value(o);
            }
            this.endArray();
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Iterable<?> value) throws IOException {
        if (value instanceof Path) {
            this.field(name);
            this.value(value);
        } else {
            this.startArray(name);
            for (Object o : value) {
                this.value(o);
            }
            this.endArray();
        }
        return this;
    }

    public XContentBuilder field(String name, boolean ... value) throws IOException {
        this.startArray(name);
        for (boolean o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, boolean ... value) throws IOException {
        this.startArray(name);
        for (boolean o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, String ... value) throws IOException {
        this.startArray(name);
        for (String o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, String ... value) throws IOException {
        this.startArray(name);
        for (String o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, Object ... value) throws IOException {
        this.startArray(name);
        for (Object o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Object ... value) throws IOException {
        this.startArray(name);
        for (Object o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, int ... value) throws IOException {
        this.startArray(name);
        int[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, int offset, int length, int ... value) throws IOException {
        assert (offset >= 0 && value.length > length);
        this.startArray(name);
        for (int i = offset; i < length; ++i) {
            this.value(value[i]);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, int ... value) throws IOException {
        this.startArray(name);
        int[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, long ... value) throws IOException {
        this.startArray(name);
        long[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, long ... value) throws IOException {
        this.startArray(name);
        long[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, float ... value) throws IOException {
        this.startArray(name);
        float[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Float o = Float.valueOf(arr$[i$]);
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, float ... value) throws IOException {
        this.startArray(name);
        float[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Float o = Float.valueOf(arr$[i$]);
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, double ... value) throws IOException {
        this.startArray(name);
        double[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Double o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, double ... value) throws IOException {
        this.startArray(name);
        double[] arr$ = value;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Double o = arr$[i$];
            this.value((Object)o);
        }
        this.endArray();
        return this;
    }

    public XContentBuilder field(String name, Object value) throws IOException {
        this.field(name);
        this.writeValue(value);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, Object value) throws IOException {
        this.field(name);
        this.writeValue(value);
        return this;
    }

    public XContentBuilder value(Object value) throws IOException {
        this.writeValue(value);
        return this;
    }

    public XContentBuilder field(String name, boolean value) throws IOException {
        this.field(name);
        this.generator.writeBoolean(value);
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, boolean value) throws IOException {
        this.field(name);
        this.generator.writeBoolean(value);
        return this;
    }

    public XContentBuilder field(String name, byte[] value) throws IOException {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeBinary(value);
        }
        return this;
    }

    public XContentBuilder field(XContentBuilderString name, byte[] value) throws IOException {
        this.field(name);
        return this.value(value);
    }

    public XContentBuilder field(String name, ReadableInstant date) throws IOException {
        this.field(name);
        return this.value(date);
    }

    public XContentBuilder field(XContentBuilderString name, ReadableInstant date) throws IOException {
        this.field(name);
        return this.value(date);
    }

    public XContentBuilder field(String name, ReadableInstant date, DateTimeFormatter formatter) throws IOException {
        this.field(name);
        return this.value(date, formatter);
    }

    public XContentBuilder field(XContentBuilderString name, ReadableInstant date, DateTimeFormatter formatter) throws IOException {
        this.field(name);
        return this.value(date, formatter);
    }

    public XContentBuilder field(String name, Date date) throws IOException {
        this.field(name);
        return this.value(date);
    }

    public XContentBuilder field(XContentBuilderString name, Date date) throws IOException {
        this.field(name);
        return this.value(date);
    }

    public XContentBuilder field(String name, Date date, DateTimeFormatter formatter) throws IOException {
        this.field(name);
        return this.value(date, formatter);
    }

    public XContentBuilder field(XContentBuilderString name, Date date, DateTimeFormatter formatter) throws IOException {
        this.field(name);
        return this.value(date, formatter);
    }

    public XContentBuilder nullField(String name) throws IOException {
        this.generator.writeNullField(name);
        return this;
    }

    public XContentBuilder nullField(XContentBuilderString name) throws IOException {
        this.field(name);
        this.generator.writeNull();
        return this;
    }

    public XContentBuilder nullValue() throws IOException {
        this.generator.writeNull();
        return this;
    }

    public XContentBuilder rawField(String fieldName, InputStream content) throws IOException {
        this.generator.writeRawField(fieldName, content);
        return this;
    }

    public XContentBuilder rawField(String fieldName, BytesReference content) throws IOException {
        this.generator.writeRawField(fieldName, content);
        return this;
    }

    public XContentBuilder rawValue(BytesReference content) throws IOException {
        this.generator.writeRawValue(content);
        return this;
    }

    public XContentBuilder timeValueField(XContentBuilderString rawFieldName, XContentBuilderString readableFieldName, TimeValue timeValue) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, timeValue.toString());
        }
        this.field(rawFieldName, timeValue.millis());
        return this;
    }

    public XContentBuilder timeValueField(XContentBuilderString rawFieldName, XContentBuilderString readableFieldName, long rawTime) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, new TimeValue(rawTime).toString());
        }
        this.field(rawFieldName, rawTime);
        return this;
    }

    public XContentBuilder dateValueField(XContentBuilderString rawFieldName, XContentBuilderString readableFieldName, long rawTimestamp) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, defaultDatePrinter.print(rawTimestamp));
        }
        this.field(rawFieldName, rawTimestamp);
        return this;
    }

    public XContentBuilder timeValueField(String rawFieldName, String readableFieldName, TimeValue timeValue) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, timeValue.toString());
        }
        this.field(rawFieldName, timeValue.millis());
        return this;
    }

    public XContentBuilder timeValueField(String rawFieldName, String readableFieldName, long rawTime, TimeUnit timeUnit) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, new TimeValue(rawTime, timeUnit).toString());
        }
        this.field(rawFieldName, rawTime);
        return this;
    }

    public XContentBuilder dateValueField(String rawFieldName, String readableFieldName, long rawTimestamp) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, defaultDatePrinter.print(rawTimestamp));
        }
        this.field(rawFieldName, rawTimestamp);
        return this;
    }

    public XContentBuilder byteSizeField(XContentBuilderString rawFieldName, XContentBuilderString readableFieldName, ByteSizeValue byteSizeValue) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, byteSizeValue.toString());
        }
        this.field(rawFieldName, byteSizeValue.bytes());
        return this;
    }

    public XContentBuilder byteSizeField(XContentBuilderString rawFieldName, XContentBuilderString readableFieldName, long rawSize) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, new ByteSizeValue(rawSize).toString());
        }
        this.field(rawFieldName, rawSize);
        return this;
    }

    public XContentBuilder percentageField(XContentBuilderString rawFieldName, XContentBuilderString readableFieldName, double percentage) throws IOException {
        if (this.humanReadable) {
            this.field(readableFieldName, String.format(Locale.ROOT, "%1.1f%%", percentage));
        }
        this.field(rawFieldName, percentage);
        return this;
    }

    public XContentBuilder value(Boolean value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value((boolean)value);
    }

    public XContentBuilder value(boolean value) throws IOException {
        this.generator.writeBoolean(value);
        return this;
    }

    public XContentBuilder value(ReadableInstant date) throws IOException {
        return this.value(date, defaultDatePrinter);
    }

    public XContentBuilder value(ReadableInstant date, DateTimeFormatter dateTimeFormatter) throws IOException {
        if (date == null) {
            return this.nullValue();
        }
        return this.value(dateTimeFormatter.print(date));
    }

    public XContentBuilder value(Date date) throws IOException {
        return this.value(date, defaultDatePrinter);
    }

    public XContentBuilder value(Date date, DateTimeFormatter dateTimeFormatter) throws IOException {
        if (date == null) {
            return this.nullValue();
        }
        return this.value(dateTimeFormatter.print(date.getTime()));
    }

    public XContentBuilder value(Integer value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value((int)value);
    }

    public XContentBuilder value(int value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder value(Long value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value((long)value);
    }

    public XContentBuilder value(long value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder value(Float value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value(value.floatValue());
    }

    public XContentBuilder value(float value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder value(Double value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        return this.value((double)value);
    }

    public XContentBuilder value(double value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public XContentBuilder value(String value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeString(value);
        return this;
    }

    public XContentBuilder value(byte[] value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeBinary(value);
        return this;
    }

    public XContentBuilder value(byte[] value, int offset, int length) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeBinary(value, offset, length);
        return this;
    }

    public XContentBuilder value(BytesRef value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        this.generator.writeBinary(value.bytes, value.offset, value.length);
        return this;
    }

    public XContentBuilder value(BytesReference value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        if (!value.hasArray()) {
            value = value.toBytesArray();
        }
        this.generator.writeBinary(value.array(), value.arrayOffset(), value.length());
        return this;
    }

    public XContentBuilder value(Text value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        if (value.hasBytes() && value.bytes().hasArray()) {
            this.generator.writeUTF8String(value.bytes().array(), value.bytes().arrayOffset(), value.bytes().length());
            return this;
        }
        if (value.hasString()) {
            this.generator.writeString(value.string());
            return this;
        }
        BytesArray bytesArray = value.bytes().toBytesArray();
        this.generator.writeUTF8String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length());
        return this;
    }

    public XContentBuilder map(Map<String, ?> map) throws IOException {
        if (map == null) {
            return this.nullValue();
        }
        this.writeMap(map);
        return this;
    }

    public XContentBuilder value(Map<String, Object> map) throws IOException {
        if (map == null) {
            return this.nullValue();
        }
        this.writeMap(map);
        return this;
    }

    public XContentBuilder value(Iterable<?> value) throws IOException {
        if (value == null) {
            return this.nullValue();
        }
        if (value instanceof Path) {
            this.writeValue(value);
        } else {
            this.startArray();
            for (Object o : value) {
                this.value(o);
            }
            this.endArray();
        }
        return this;
    }

    public XContentBuilder latlon(String name, double lat, double lon) throws IOException {
        return this.startObject(name).field("lat", lat).field("lon", lon).endObject();
    }

    public XContentBuilder latlon(double lat, double lon) throws IOException {
        return this.startObject().field("lat", lat).field("lon", lon).endObject();
    }

    public XContentBuilder copyCurrentStructure(XContentParser parser) throws IOException {
        this.generator.copyCurrentStructure(parser);
        return this;
    }

    public XContentBuilder flush() throws IOException {
        this.generator.flush();
        return this;
    }

    @Override
    public void close() {
        try {
            this.generator.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public XContentGenerator generator() {
        return this.generator;
    }

    @Override
    public BytesReference bytes() {
        this.close();
        return ((BytesStream)((Object)this.bos)).bytes();
    }

    public String string() throws IOException {
        this.close();
        BytesArray bytesArray = this.bytes().toBytesArray();
        return new String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length(), Charsets.UTF_8);
    }

    private void writeMap(Map<String, ?> map) throws IOException {
        this.generator.writeStartObject();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.field(entry.getKey());
            Object value = entry.getValue();
            if (value == null) {
                this.generator.writeNull();
                continue;
            }
            this.writeValue(value);
        }
        this.generator.writeEndObject();
    }

    private void writeValue(Object value) throws IOException {
        if (value == null) {
            this.generator.writeNull();
            return;
        }
        Class<?> type = value.getClass();
        if (type == String.class) {
            this.generator.writeString((String)value);
        } else if (type == Integer.class) {
            this.generator.writeNumber((Integer)value);
        } else if (type == Long.class) {
            this.generator.writeNumber((Long)value);
        } else if (type == Float.class) {
            this.generator.writeNumber(((Float)value).floatValue());
        } else if (type == Double.class) {
            this.generator.writeNumber((Double)value);
        } else if (type == Byte.class) {
            this.generator.writeNumber(((Byte)value).byteValue());
        } else if (type == Short.class) {
            this.generator.writeNumber(((Short)value).shortValue());
        } else if (type == Boolean.class) {
            this.generator.writeBoolean((Boolean)value);
        } else if (type == GeoPoint.class) {
            this.generator.writeStartObject();
            this.generator.writeNumberField("lat", ((GeoPoint)value).lat());
            this.generator.writeNumberField("lon", ((GeoPoint)value).lon());
            this.generator.writeEndObject();
        } else if (value instanceof Map) {
            this.writeMap((Map)value);
        } else if (value instanceof Path) {
            this.generator.writeString(value.toString());
        } else if (value instanceof Iterable) {
            this.generator.writeStartArray();
            for (Object v : (Iterable)value) {
                this.writeValue(v);
            }
            this.generator.writeEndArray();
        } else if (value instanceof Object[]) {
            this.generator.writeStartArray();
            for (Object v : (Object[])value) {
                this.writeValue(v);
            }
            this.generator.writeEndArray();
        } else if (type == byte[].class) {
            this.generator.writeBinary((byte[])value);
        } else if (value instanceof Date) {
            this.generator.writeString(defaultDatePrinter.print(((Date)value).getTime()));
        } else if (value instanceof Calendar) {
            this.generator.writeString(defaultDatePrinter.print(((Calendar)value).getTimeInMillis()));
        } else if (value instanceof ReadableInstant) {
            this.generator.writeString(defaultDatePrinter.print(((ReadableInstant)value).getMillis()));
        } else if (value instanceof BytesReference) {
            BytesReference bytes = (BytesReference)value;
            if (!bytes.hasArray()) {
                bytes = bytes.toBytesArray();
            }
            this.generator.writeBinary(bytes.array(), bytes.arrayOffset(), bytes.length());
        } else if (value instanceof BytesRef) {
            BytesRef bytes = (BytesRef)value;
            this.generator.writeBinary(bytes.bytes, bytes.offset, bytes.length);
        } else if (value instanceof Text) {
            Text text = (Text)value;
            if (text.hasBytes() && text.bytes().hasArray()) {
                this.generator.writeUTF8String(text.bytes().array(), text.bytes().arrayOffset(), text.bytes().length());
            } else if (text.hasString()) {
                this.generator.writeString(text.string());
            } else {
                BytesArray bytesArray = text.bytes().toBytesArray();
                this.generator.writeUTF8String(bytesArray.array(), bytesArray.arrayOffset(), bytesArray.length());
            }
        } else if (value instanceof ToXContent) {
            ((ToXContent)value).toXContent(this, ToXContent.EMPTY_PARAMS);
        } else if (value instanceof double[]) {
            this.generator.writeStartArray();
            for (double v : (double[])value) {
                this.generator.writeNumber(v);
            }
            this.generator.writeEndArray();
        } else if (value instanceof long[]) {
            this.generator.writeStartArray();
            for (long v : (long[])value) {
                this.generator.writeNumber(v);
            }
            this.generator.writeEndArray();
        } else if (value instanceof int[]) {
            this.generator.writeStartArray();
            for (int v : (int[])value) {
                this.generator.writeNumber(v);
            }
            this.generator.writeEndArray();
        } else if (value instanceof float[]) {
            this.generator.writeStartArray();
            for (float v : (float[])value) {
                this.generator.writeNumber(v);
            }
            this.generator.writeEndArray();
        } else if (value instanceof short[]) {
            this.generator.writeStartArray();
            for (short v : (short[])value) {
                this.generator.writeNumber(v);
            }
            this.generator.writeEndArray();
        } else {
            this.generator.writeString(value.toString());
        }
    }

    public static enum FieldCaseConversion {
        NONE,
        UNDERSCORE,
        CAMELCASE;

    }
}

