/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericIntegerAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class IntegerFieldMapper
extends NumberFieldMapper {
    public static final String CONTENT_TYPE = "integer";

    protected IntegerFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, indexSettings, multiFields, copyTo);
    }

    @Override
    public IntegerFieldType fieldType() {
        return (IntegerFieldType)super.fieldType();
    }

    private static int parseValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof BytesRef) {
            return Integer.parseInt(((BytesRef)value).utf8ToString());
        }
        return Integer.parseInt(value.toString());
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<Field> fields) throws IOException {
        int value;
        float boost = this.fieldType().boost();
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.fieldType().nullValue() == null) {
                    return;
                }
                value = this.fieldType().nullValue();
            } else if (externalValue instanceof String) {
                String sExternalValue = (String)externalValue;
                if (sExternalValue.length() == 0) {
                    if (this.fieldType().nullValue() == null) {
                        return;
                    }
                    value = this.fieldType().nullValue();
                } else {
                    value = Integer.parseInt(sExternalValue);
                }
            } else {
                value = ((Number)externalValue).intValue();
            }
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.fieldType().names().fullName(), Integer.toString(value), boost);
            }
        } else {
            XContentParser parser = context.parser();
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL || parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
                if (this.fieldType().nullValue() == null) {
                    return;
                }
                value = this.fieldType().nullValue();
                if (this.fieldType().nullValueAsString() != null && context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.fieldType().names().fullName(), this.fieldType().nullValueAsString(), boost);
                }
            } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                String currentFieldName = null;
                Integer objValue = this.fieldType().nullValue();
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        objValue = parser.intValue((Boolean)this.coerce.value());
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new IllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
                if (objValue == null) {
                    return;
                }
                value = objValue;
            } else {
                value = parser.intValue((Boolean)this.coerce.value());
                if (context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.fieldType().names().fullName(), parser.text(), boost);
                }
            }
        }
        this.addIntegerFields(context, fields, value, boost);
    }

    protected void addIntegerFields(ParseContext context, List<Field> fields, int value, float boost) {
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            CustomIntegerNumericField field = new CustomIntegerNumericField(value, (MappedFieldType)this.fieldType());
            field.setBoost(boost);
            fields.add(field);
        }
        if (this.fieldType().hasDocValues()) {
            this.addDocValue(context, fields, value);
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().numericPrecisionStep() != 8) {
            builder.field("precision_step", this.fieldType().numericPrecisionStep());
        }
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    public static class CustomIntegerNumericField
    extends NumberFieldMapper.CustomNumericField {
        private final int number;

        public CustomIntegerNumericField(int number, MappedFieldType fieldType) {
            super(number, fieldType);
            this.number = number;
        }

        public TokenStream tokenStream(Analyzer analyzer, TokenStream previous) {
            if (this.fieldType().indexOptions() != IndexOptions.NONE) {
                return this.getCachedStream().setIntValue(this.number);
            }
            return null;
        }

        @Override
        public String numericAsString() {
            return Integer.toString(this.number);
        }
    }

    public static final class IntegerFieldType
    extends NumberFieldMapper.NumberFieldType {
        private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(IntegerFieldType.class));

        public IntegerFieldType() {
            super(FieldType.NumericType.INT);
        }

        protected IntegerFieldType(IntegerFieldType ref) {
            super(ref);
        }

        @Override
        public NumberFieldMapper.NumberFieldType clone() {
            return new IntegerFieldType(this);
        }

        @Override
        public String typeName() {
            return "int";
        }

        @Override
        public Integer nullValue() {
            return (Integer)super.nullValue();
        }

        @Override
        public Integer value(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof BytesRef) {
                return Numbers.bytesToInt((BytesRef)value);
            }
            return Integer.parseInt(value.toString());
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            BytesRefBuilder bytesRef = new BytesRefBuilder();
            NumericUtils.intToPrefixCoded((int)IntegerFieldMapper.parseValue(value), (int)0, (BytesRefBuilder)bytesRef);
            return bytesRef.get();
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper) {
            return NumericRangeQuery.newIntRange((String)this.names().indexName(), (int)this.numericPrecisionStep(), (Integer)(lowerTerm == null ? null : Integer.valueOf(IntegerFieldMapper.parseValue(lowerTerm))), (Integer)(upperTerm == null ? null : Integer.valueOf(IntegerFieldMapper.parseValue(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
        }

        @Override
        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
            DEPRECATION_LOGGER.deprecated("Fuzzy query on field [{}] of type [{}] is deprecated. The next version will only support it on text/keyword fields", this.names().fullName(), this.typeName());
            int iValue = IntegerFieldMapper.parseValue(value);
            int iSim = fuzziness.asInt();
            return NumericRangeQuery.newIntRange((String)this.names().indexName(), (int)this.numericPrecisionStep(), (Integer)(iValue - iSim), (Integer)(iValue + iSim), (boolean)true, (boolean)true);
        }

        @Override
        public FieldStats stats(Terms terms, int maxDoc) throws IOException {
            long minValue = NumericUtils.getMinInt((Terms)terms).intValue();
            long maxValue = NumericUtils.getMaxInt((Terms)terms).intValue();
            return new FieldStats.Long(maxDoc, terms.getDocCount(), terms.getSumDocFreq(), terms.getSumTotalTermFreq(), minValue, maxValue);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.integerField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                if (propNode == null) {
                    throw new MapperParsingException("Property [null_value] cannot be null.");
                }
                builder.nullValue(XContentMapValues.nodeIntegerValue(propNode));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, IntegerFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, 8);
            this.builder = this;
        }

        public Builder nullValue(int nullValue) {
            this.fieldType.setNullValue(nullValue);
            return this;
        }

        @Override
        public IntegerFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            IntegerFieldMapper fieldMapper = new IntegerFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
            return (IntegerFieldMapper)fieldMapper.includeInAll(this.includeInAll);
        }

        @Override
        protected NamedAnalyzer makeNumberAnalyzer(int precisionStep) {
            return NumericIntegerAnalyzer.buildNamedAnalyzer(precisionStep);
        }

        @Override
        protected int maxPrecisionStep() {
            return 32;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final MappedFieldType FIELD_TYPE = new IntegerFieldType();

        static {
            FIELD_TYPE.freeze();
        }
    }
}

