/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class GeoShapeQueryBuilder
extends QueryBuilder
implements BoostableQueryBuilder<GeoShapeQueryBuilder> {
    private final String name;
    private final ShapeBuilder shape;
    private SpatialStrategy strategy = null;
    private String queryName;
    private final String indexedShapeId;
    private final String indexedShapeType;
    private String indexedShapeIndex;
    private String indexedShapePath;
    private ShapeRelation relation = null;
    private float boost = -1.0f;

    public GeoShapeQueryBuilder(String name, ShapeBuilder shape) {
        this(name, shape, null, null, null);
    }

    public GeoShapeQueryBuilder(String name, ShapeBuilder shape, ShapeRelation relation) {
        this(name, shape, null, null, relation);
    }

    public GeoShapeQueryBuilder(String name, String indexedShapeId, String indexedShapeType, ShapeRelation relation) {
        this(name, null, indexedShapeId, indexedShapeType, relation);
    }

    private GeoShapeQueryBuilder(String name, ShapeBuilder shape, String indexedShapeId, String indexedShapeType, ShapeRelation relation) {
        this.name = name;
        this.shape = shape;
        this.indexedShapeId = indexedShapeId;
        this.relation = relation;
        this.indexedShapeType = indexedShapeType;
    }

    public GeoShapeQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public GeoShapeQueryBuilder strategy(SpatialStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public GeoShapeQueryBuilder indexedShapeIndex(String indexedShapeIndex) {
        this.indexedShapeIndex = indexedShapeIndex;
        return this;
    }

    public GeoShapeQueryBuilder indexedShapePath(String indexedShapePath) {
        this.indexedShapePath = indexedShapePath;
        return this;
    }

    public GeoShapeQueryBuilder relation(ShapeRelation relation) {
        this.relation = relation;
        return this;
    }

    @Override
    public GeoShapeQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("geo_shape");
        builder.startObject(this.name);
        if (this.strategy != null) {
            builder.field("strategy", this.strategy.getStrategyName());
        }
        if (this.shape != null) {
            builder.field("shape", this.shape);
        } else {
            builder.startObject("indexed_shape").field("id", this.indexedShapeId).field("type", this.indexedShapeType);
            if (this.indexedShapeIndex != null) {
                builder.field("index", this.indexedShapeIndex);
            }
            if (this.indexedShapePath != null) {
                builder.field("path", this.indexedShapePath);
            }
            builder.endObject();
        }
        if (this.relation != null) {
            builder.field("relation", this.relation.getRelationName());
        }
        builder.endObject();
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.name != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

