/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.support.NestedInnerQueryParseSupport;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortParser;

public class GeoDistanceSortParser
implements SortParser {
    private static final ParseField REVERSE_FIELD = new ParseField("reverse", new String[0]).withAllDeprecated("replaced by order");

    @Override
    public String[] names() {
        return new String[]{"_geo_distance", "_geoDistance"};
    }

    @Override
    public SortField parse(XContentParser parser, SearchContext context) throws Exception {
        IndexFieldData.XFieldComparatorSource.Nested nested;
        XContentParser.Token token;
        String fieldName = null;
        ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
        DistanceUnit unit = DistanceUnit.DEFAULT;
        GeoDistance geoDistance = GeoDistance.DEFAULT;
        boolean reverse = false;
        MultiValueMode sortMode = null;
        NestedInnerQueryParseSupport nestedHelper = null;
        boolean indexCreatedBeforeV2_0 = context.queryParserService().getIndexCreatedVersion().before(Version.V_2_0_0);
        boolean coerce = false;
        boolean ignoreMalformed = false;
        String currentName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            GeoPoint point;
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                this.parseGeoPoints(parser, geoPoints);
                fieldName = currentName;
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("nested_filter".equals(currentName) || "nestedFilter".equals(currentName)) {
                    if (nestedHelper == null) {
                        nestedHelper = new NestedInnerQueryParseSupport(parser, context);
                    }
                    nestedHelper.filter();
                    continue;
                }
                fieldName = currentName;
                point = new GeoPoint();
                GeoUtils.parseGeoPoint(parser, point);
                geoPoints.add(point);
                continue;
            }
            if (!token.isValue()) continue;
            if (context.parseFieldMatcher().match(currentName, REVERSE_FIELD)) {
                reverse = parser.booleanValue();
                continue;
            }
            if ("order".equals(currentName)) {
                reverse = "desc".equals(parser.text());
                continue;
            }
            if (currentName.equals("unit")) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (currentName.equals("distance_type") || currentName.equals("distanceType")) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if ("coerce".equals(currentName) || indexCreatedBeforeV2_0 && "normalize".equals(currentName)) {
                coerce = parser.booleanValue();
                if (!coerce) continue;
                ignoreMalformed = true;
                continue;
            }
            if ("ignore_malformed".equals(currentName) && !coerce) {
                ignoreMalformed = parser.booleanValue();
                continue;
            }
            if ("sort_mode".equals(currentName) || "sortMode".equals(currentName) || "mode".equals(currentName)) {
                sortMode = MultiValueMode.fromString(parser.text());
                continue;
            }
            if ("nested_path".equals(currentName) || "nestedPath".equals(currentName)) {
                if (nestedHelper == null) {
                    nestedHelper = new NestedInnerQueryParseSupport(parser, context);
                }
                nestedHelper.setPath(parser.text());
                continue;
            }
            point = new GeoPoint();
            point.resetFromString(parser.text());
            geoPoints.add(point);
            fieldName = currentName;
        }
        if (!indexCreatedBeforeV2_0 && !ignoreMalformed) {
            for (GeoPoint point : geoPoints) {
                if (point.lat() > 90.0 || point.lat() < -90.0) {
                    throw new ElasticsearchParseException("illegal latitude value [{}] for [GeoDistanceSort]", point.lat());
                }
                if (!(point.lon() > 180.0) && !(point.lon() < -180.0)) continue;
                throw new ElasticsearchParseException("illegal longitude value [{}] for [GeoDistanceSort]", point.lon());
            }
        }
        if (coerce) {
            for (GeoPoint point : geoPoints) {
                GeoUtils.normalizePoint(point, coerce, coerce);
            }
        }
        if (sortMode == null) {
            MultiValueMode multiValueMode = sortMode = reverse ? MultiValueMode.MAX : MultiValueMode.MIN;
        }
        if (sortMode == MultiValueMode.SUM) {
            throw new IllegalArgumentException("sort_mode [sum] isn't supported for sorting by geo distance");
        }
        MappedFieldType fieldType = context.smartNameFieldType(fieldName);
        if (fieldType == null) {
            throw new IllegalArgumentException("failed to find mapper for [" + fieldName + "] for geo distance based sort");
        }
        final MultiValueMode finalSortMode = sortMode;
        final IndexGeoPointFieldData geoIndexFieldData = (IndexGeoPointFieldData)context.fieldData().getForField(fieldType);
        final GeoDistance.FixedSourceDistance[] distances = new GeoDistance.FixedSourceDistance[geoPoints.size()];
        for (int i = 0; i < geoPoints.size(); ++i) {
            distances[i] = geoDistance.fixedSourceDistance(((GeoPoint)geoPoints.get(i)).lat(), ((GeoPoint)geoPoints.get(i)).lon(), unit);
        }
        if (nestedHelper != null && nestedHelper.getPath() != null) {
            BitSetProducer rootDocumentsFilter = context.bitsetFilterCache().getBitSetProducer(Queries.newNonNestedFilter());
            Query innerDocumentsFilter = nestedHelper.filterFound() ? nestedHelper.getInnerFilter() : nestedHelper.getNestedObjectMapper().nestedTypeFilter();
            nested = new IndexFieldData.XFieldComparatorSource.Nested(rootDocumentsFilter, context.searcher().createNormalizedWeight(innerDocumentsFilter, false));
        } else {
            nested = null;
        }
        IndexFieldData.XFieldComparatorSource geoDistanceComparatorSource = new IndexFieldData.XFieldComparatorSource(){

            @Override
            public SortField.Type reducedType() {
                return SortField.Type.DOUBLE;
            }

            public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                return new FieldComparator.DoubleComparator(numHits, null, null){

                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        NumericDoubleValues selectedValues;
                        MultiGeoPointValues geoPointValues = ((AtomicGeoPointFieldData)geoIndexFieldData.load(context)).getGeoPointValues();
                        SortedNumericDoubleValues distanceValues = GeoDistance.distanceValues(geoPointValues, distances);
                        if (nested == null) {
                            selectedValues = finalSortMode.select(distanceValues, Double.MAX_VALUE);
                        } else {
                            BitSet rootDocs = nested.rootDocs(context);
                            DocIdSetIterator innerDocs = nested.innerDocs(context);
                            selectedValues = finalSortMode.select(distanceValues, Double.MAX_VALUE, rootDocs, innerDocs, context.reader().maxDoc());
                        }
                        return selectedValues.getRawDoubleValues();
                    }
                };
            }
        };
        return new SortField(fieldName, (FieldComparatorSource)geoDistanceComparatorSource, reverse);
    }

    private void parseGeoPoints(XContentParser parser, List<GeoPoint> geoPoints) throws IOException {
        while (!parser.nextToken().equals((Object)XContentParser.Token.END_ARRAY)) {
            if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                double lon = parser.doubleValue();
                parser.nextToken();
                if (!parser.currentToken().equals((Object)XContentParser.Token.VALUE_NUMBER)) {
                    throw new ElasticsearchParseException("geo point parsing: expected second number but got [{}] instead", new Object[]{parser.currentToken()});
                }
                double lat = parser.doubleValue();
                GeoPoint point = new GeoPoint();
                point.reset(lat, lon);
                geoPoints.add(point);
                continue;
            }
            GeoPoint point = new GeoPoint();
            GeoUtils.parseGeoPoint(parser, point);
            geoPoints.add(point);
        }
    }
}

