/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.assetkey;

import com.tandbergtv.metadatamanager.assetkey.PgQueryBuilder;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.ValidatorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AssetKeyManager {
    private static Map<String, String> indexedFieldMapping = new HashMap<String, String>();
    private static AssetKeyManager idManager = null;
    private static final Logger logger = Logger.getLogger(AssetKeyManager.class);

    public static AssetKeyManager getInstance() {
        if (idManager == null) {
            idManager = new AssetKeyManager();
        }
        return idManager;
    }

    private AssetKeyManager() {
        this.buildInitialIndexedFieldMappings();
        logger.info((Object)("Spec Key Mapping:" + indexedFieldMapping.toString()));
    }

    private void buildInitialIndexedFieldMappings() {
        Collection<ISpecHandler> specs = this.getSpecificationHandlersForValidation();
        HashSet<String> key_xpaths = new HashSet<String>();
        for (ISpecHandler spec : specs) {
            String specName = spec.getSpecName();
            IdentifierBase id = spec.getIdentifier();
            Map<String, String> specIdFieldMappings = id.getTTVPaths();
            this.getAllKeyXpaths(specIdFieldMappings, key_xpaths);
        }
        for (String xpath : key_xpaths) {
            String indexedJsonFieldName = PgQueryBuilder.getJsonPath(xpath);
            indexedFieldMapping.put(xpath, indexedJsonFieldName);
        }
    }

    private void getAllKeyXpaths(Map<String, String> specIdFieldMappings, Set<String> string_fields) {
        Set<String> spec_keys = specIdFieldMappings.keySet();
        for (String spec_key : spec_keys) {
            String xpath = specIdFieldMappings.get(spec_key);
            string_fields.add(xpath);
        }
    }

    private Collection<ISpecHandler> getSpecificationHandlersForValidation() {
        ValidatorHelper helper = ValidatorHelper.getInstance();
        return helper.getSpecificationHandlersForValidation();
    }

    public String getIndexedFieldName(String xpath) {
        return indexedFieldMapping.get(xpath);
    }

    public Set<String> getAllSpecIdXpaths() {
        return indexedFieldMapping.keySet();
    }

    public boolean checkForOutOfSyncIndexedFields(Set<String> curIndexedXpaths) {
        boolean inSync = false;
        Set<String> xpaths = AssetKeyManager.getInstance().getAllSpecIdXpaths();
        ArrayList<String> removedIndexList = new ArrayList<String>();
        ArrayList<String> newIndexList = new ArrayList<String>();
        for (String curIndexedXpath : curIndexedXpaths) {
            if (xpaths.contains(curIndexedXpath)) continue;
            removedIndexList.add(curIndexedXpath);
        }
        for (String xpath : xpaths) {
            if (curIndexedXpaths.contains(xpath)) continue;
            newIndexList.add(xpath);
        }
        logger.info((Object)("Old indexes (invalid):" + ((Object)removedIndexList).toString()));
        logger.info((Object)("New indexes (missing):" + ((Object)newIndexList).toString()));
        if (removedIndexList.isEmpty() && newIndexList.isEmpty()) {
            inSync = true;
            logger.info((Object)"All indexes match identifiers from all metadata plugins.");
        }
        return inSync;
    }
}

