/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.assetkey;

import com.tandbergtv.metadatamanager.assetkey.IdDAO;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class PgQueryBuilder {
    public String sqlForAssetUniquenessQuery(SearchCriteria criteria) {
        StringBuilder query = new StringBuilder();
        query.append("select 1 from ");
        query.append(IdDAO.assetKeyTable);
        query.append(" where ");
        query.append(this.buildWhereCondition(criteria));
        return query.toString();
    }

    public String sqlForDocumentIdQuery(SearchCriteria criteria) {
        StringBuilder query = new StringBuilder();
        query.append("select ");
        query.append(IdDAO.documentIdColumn);
        query.append(" from ");
        query.append(IdDAO.assetKeyTable);
        query.append(" where ");
        query.append(this.buildWhereCondition(criteria));
        return query.toString();
    }

    public String sqlForFullDocumentQuery(SearchCriteria criteria) {
        String keysAlias = "k";
        String mdmAlias = "mdm";
        StringBuilder query = new StringBuilder();
        query.append("select XMLSERIALIZE(content " + mdmAlias + ".document as text) \r\n");
        query.append("from mdm_metadata " + mdmAlias + "\r\n");
        query.append(" where ");
        query.append(mdmAlias + ".document_id in ");
        query.append("(");
        query.append("select ");
        query.append(keysAlias + "." + IdDAO.documentIdColumn);
        query.append(" from ");
        query.append(IdDAO.assetKeyTable + " " + keysAlias);
        query.append(" where ");
        query.append(this.buildWhereCondition(criteria));
        query.append(")");
        return query.toString();
    }

    private String buildWhereCondition(SearchCriteria criteria) {
        Iterator iter = criteria.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (iter.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(" and ");
            }
            Map.Entry entry = iter.next();
            sb.append((String)entry.getKey());
            sb.append("='");
            sb.append((String)entry.getValue());
            sb.append("'");
        }
        return sb.toString();
    }

    private static String encodeField(String value, boolean isForSql) {
        return isForSql ? "''" + value + "''" : "'" + value + "'";
    }

    public String getInsertSql(Map<String, String> colValuePairs) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ");
        sql.append(IdDAO.assetKeyTable);
        Set<String> names = colValuePairs.keySet();
        StringBuilder cols = new StringBuilder();
        cols.append("(");
        int i = 0;
        for (String name : names) {
            cols.append(name);
            if (i++ >= cols.length() - 1) continue;
            cols.append(",");
        }
        cols.append(")");
        StringBuilder vals = new StringBuilder();
        vals.append("(");
        i = 0;
        for (String name : names) {
            vals.append("'" + colValuePairs.get(name) + "'");
            if (i++ >= cols.length() - 1) continue;
            cols.append(",");
        }
        cols.append(")");
        sql.append(" " + cols.toString());
        sql.append(" " + vals.toString());
        return sql.toString();
    }

    public static String getJsonPath(String xpath) {
        return PgQueryBuilder.getJsonPath(xpath, false);
    }

    public static String getJsonPath(String xpath, boolean isForSql) {
        StringBuilder sb = new StringBuilder();
        String[] toks = xpath.split("/");
        int i = 0;
        sb.append(IdDAO.keysJsonColumn);
        sb.append("->");
        for (String tok : toks) {
            if (tok.trim().isEmpty()) continue;
            sb.append(PgQueryBuilder.encodeField(tok, isForSql));
            if (i < toks.length - 3) {
                sb.append("->");
            } else if (i == toks.length - 3) {
                sb.append("->>");
            }
            ++i;
        }
        return sb.toString();
    }

    public String sqlForQueryDuplicatedAssetId(Collection<String> ttvPaths) {
        StringBuilder sb = new StringBuilder();
        sb.append("select array_agg(asset_id), count(*) from ");
        sb.append(IdDAO.assetKeyTable);
        sb.append(" group by ");
        ArrayList<String> jsonPathList = new ArrayList<String>();
        for (String xpath : ttvPaths) {
            jsonPathList.add(PgQueryBuilder.getJsonPath(xpath));
        }
        sb.append(StringUtils.join(jsonPathList, (char)','));
        sb.append(" having count(*) > 1");
        for (String xpath : ttvPaths) {
            sb.append(" and ");
            sb.append(PgQueryBuilder.getJsonPath(xpath));
            sb.append(" != ''");
        }
        return sb.toString();
    }

    public String sqlForQueryTitleIdFromAssetId() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("select t.id_ from pmm_title t, mdm_asset_identifier f where t.mdmdocid = f.document_id and f.asset_id = ?");
        return sb.toString();
    }

    public String sqlForCreateUniqueIndexOnIdentifiers(String indexName, Collection<String> ttvPaths) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT FUNC_CREATE_MDM_AI_IDX ( ");
        sb.append("'" + indexName + "', '");
        ArrayList<String> jsonList = new ArrayList<String>();
        for (String ttvPath : ttvPaths) {
            String jsonString = "(" + PgQueryBuilder.getJsonPath(ttvPath, true) + ")";
            jsonList.add(jsonString);
        }
        sb.append(StringUtils.join(jsonList, (String)","));
        sb.append("');");
        return sb.toString();
    }

    public static void main(String[] args) {
        PgQueryBuilder test = new PgQueryBuilder();
        System.out.println(PgQueryBuilder.getJsonPath("/Fields/ProviderInfo/Identifier/Id"));
        System.out.println(PgQueryBuilder.getJsonPath("/Fields/Identifier/Id"));
        System.out.println(PgQueryBuilder.getJsonPath("/Fields/AssetName"));
        SearchCriteria c = new SearchCriteria();
        c.put("keys->'Fields'->>'AssetName'", "Batman");
        c.put("keys->'Fields'->'ProviderInfo'->'Identifier'->>'Id'", "TTV.COM");
        c.put("keys->'Fields'->'Identifier'->>'Id'", "CMP33333333333333");
        System.out.println(test.sqlForAssetUniquenessQuery(c));
    }
}

