/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.oracle;

import com.tandbergtv.metadatamanager.MetadataManagerDAOImpl;
import com.tandbergtv.metadatamanager.search.MDMTable;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.apache.log4j.Logger;
import org.hibernate.jdbc.Work;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class GetMetadata
implements Work {
    private static final Logger logger = Logger.getLogger(MetadataManagerDAOImpl.class);
    private static final String SQL_COMMON_1 = "]' PASSING object_value AS \"p\")";
    protected String sql;
    protected MDMTable mdmType;
    private List<Document> docs = new ArrayList<Document>();

    public GetMetadata(MDMTable mdmType, long documentId, int revision) {
        this.mdmType = mdmType;
        this.buildSql(documentId, revision);
    }

    protected void buildSql(long documentId, int revision) {
        StringBuilder s = new StringBuilder("SELECT XMLSERIALIZE(content x.OBJECT_VALUE as clob no indent) FROM ");
        s.append(this.mdmType.getTableName() + " x");
        s.append(" WHERE XMLExists('$p/ECMFSpec[@documentId=");
        s.append(documentId);
        if (this.mdmType == MDMTable.REVISION) {
            s.append(" and @revision=");
            s.append(revision);
        }
        s.append(SQL_COMMON_1);
        this.sql = s.toString();
    }

    public GetMetadata(String sql) {
        this.sql = sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection con) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        DocumentBuilder builder = null;
        try {
            logger.debug((Object)this.sql);
            st = con.prepareStatement(this.sql);
            rs = st.executeQuery();
            builder = XmlUtil.borrowDocumentBuilder();
            ResultSetMetaData metadata = rs.getMetaData();
            int columnType = metadata.getColumnType(1);
            while (rs.next()) {
                Reader r = null;
                Clob c = null;
                if (columnType == 2005) {
                    c = rs.getClob(1);
                    r = c.getCharacterStream();
                } else {
                    r = new StringReader(rs.getString(1));
                }
                Document doc = builder.parse(new InputSource(r));
                this.docs.add(doc);
                if (c != null) {
                    c.free();
                }
                if (r == null) continue;
                r.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
    }

    public List<Document> getDocuments() {
        return this.docs;
    }
}

