/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util.binder;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.File;
import com.tandbergtv.metadatamanager.model.FileType;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Item;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.XmlUtil;
import com.tandbergtv.metadatamanager.util.binder.AssetType;
import com.tandbergtv.metadatamanager.util.binder.ECMFFieldBinder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ECMFDocToAssetConverter {
    private DocumentBuilder builder;
    private int revisionNumber = 1;
    private int originalRevisionNumber = -1;
    private static final Logger logger = Logger.getLogger(ECMFDocToAssetConverter.class);

    public List<Asset> convert(Document doc) {
        String orgDocVersion;
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        if (doc.getDocumentElement().getAttribute("revision") != "") {
            this.revisionNumber = Integer.valueOf(doc.getDocumentElement().getAttribute("revision"));
        }
        if ((orgDocVersion = doc.getDocumentElement().getAttribute("originalDocumentRevision")) != null && !orgDocVersion.isEmpty()) {
            this.originalRevisionNumber = Integer.valueOf(orgDocVersion);
        }
        NodeList nodeList = doc.getDocumentElement().getChildNodes();
        String seriesDocId = doc.getDocumentElement().getAttribute("seriesDocumentId");
        String seasonAssetId = doc.getDocumentElement().getAttribute("seasonAssetId");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node rootAssetNode = nodeList.item(i);
            if (rootAssetNode.getNodeType() != 1) continue;
            Element rootAssetElement = (Element)rootAssetNode;
            Group rootAsset = null;
            if (!rootAssetElement.getNodeName().equalsIgnoreCase(Group.GroupType.PACKAGE.name()) && !rootAssetElement.getNodeName().equalsIgnoreCase(Group.GroupType.SERIES.name())) continue;
            rootAsset = new Group();
            if (rootAssetElement.getNodeName().equalsIgnoreCase(Group.GroupType.PACKAGE.name())) {
                rootAsset.setType(Group.GroupType.PACKAGE.name());
                if (seriesDocId != null && !seriesDocId.isEmpty()) {
                    rootAsset.setSeriesDocumentId(Long.valueOf(seriesDocId));
                    if (seasonAssetId != null && !seasonAssetId.isEmpty()) {
                        rootAsset.setSeasonAssetId(Long.valueOf(seasonAssetId));
                    }
                }
            } else {
                rootAsset.setType(Group.GroupType.SERIES.name());
            }
            this.prepAsset(rootAsset, rootAssetElement, true);
            for (int j = 0; j < rootAssetNode.getChildNodes().getLength(); ++j) {
                Node packageChild = rootAssetNode.getChildNodes().item(j);
                if (!(packageChild instanceof Element)) continue;
                if (rootAsset.getType().equals(Group.GroupType.PACKAGE.name()) && this.isRefTitleId((Element)packageChild)) {
                    this.addRefTitleId((Element)packageChild, rootAsset);
                    continue;
                }
                Asset childAsset = this.getAsset((Element)packageChild);
                if (childAsset != null) {
                    rootAsset.addChild(childAsset);
                    continue;
                }
                logger.debug((Object)("Could not create asset for child: " + (Element)packageChild));
            }
            this.setAllDescFields(rootAsset);
            this.setAllDescAssets(rootAsset);
            Asset.setPaths(rootAsset, null);
            assetList.add(rootAsset);
        }
        return assetList;
    }

    private void addRefTitleId(Element element, Group rootAsset) {
        Element rId = element;
        String value = null;
        if (rId.getFirstChild() != null) {
            value = rId.getFirstChild().getNodeValue();
        }
        if (value != null) {
            Long titleId = Long.valueOf(value);
            rootAsset.addReferencedTitleId(titleId);
        } else if (rootAsset.getReferencedTitleIds() == null) {
            rootAsset.setReferencedTitleIds(new ArrayList<Long>());
        }
    }

    private boolean isRefTitleId(Element element) {
        return element.getNodeName().equalsIgnoreCase("ReferencedTitleId");
    }

    private void setAllDescAssets(Asset packageAsset) {
        packageAsset.setAllDescendantAssets(packageAsset.getAllAssets(true));
    }

    private void setAllDescFields(Asset packageAsset) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        List<Asset> allChildAssets = packageAsset.getAllAssets(true);
        for (Asset a : allChildAssets) {
            allFields.addAll(a.getFields());
        }
        packageAsset.setAllDescendantAssetFields(allFields);
    }

    private Asset prepAsset(Asset asset, Element assetElement, boolean setOriginalRevisionNumber) {
        Element upFields;
        StringBuilder assetLineage = new StringBuilder();
        this.getAssetLineage(assetElement, assetLineage);
        Document fieldDoc = this.getFieldsDoc(assetElement);
        List<Field> parsableFields = new ECMFFieldBinder().extractXPaths(fieldDoc);
        for (Field f : parsableFields) {
            f.setParentAsset(asset);
        }
        asset.setFields(parsableFields);
        if (this.getNamedChildren(assetElement, "UnparsableFields").size() == 1 && (upFields = this.getNamedChildren(assetElement, "UnparsableFields").get(0)) != null) {
            List<Field> up = new ECMFFieldBinder().getUnParsableFields(upFields);
            for (Field f : up) {
                asset.addField(f);
                f.setParentAsset(asset);
            }
        }
        long id = 0L;
        if (assetElement.getAttribute("assetId") != "") {
            id = Long.valueOf(assetElement.getAttribute("assetId"));
        }
        id = id == -1L ? 0L : id;
        asset.setTTVId(new TTVId(id));
        asset.setLatestRevisionNumber(this.revisionNumber);
        String orgAssetId = assetElement.getAttribute("originalAssetId");
        if (orgAssetId != null && !orgAssetId.isEmpty()) {
            asset.setOriginalAssetID(Long.valueOf(orgAssetId));
        }
        if (setOriginalRevisionNumber && this.originalRevisionNumber != -1) {
            asset.setOriginalRevisionNumber(this.originalRevisionNumber);
        }
        return asset;
    }

    private void getAssetLineage(Element assetElement, StringBuilder assetLineage) {
        if (assetElement == null) {
            return;
        }
        if (assetElement.getParentNode() != null && !assetElement.getParentNode().getNodeName().equalsIgnoreCase("ECMFSpec")) {
            this.getAssetLineage((Element)assetElement.getParentNode(), assetLineage);
        }
        if (assetLineage.length() > 0) {
            assetLineage.append("/");
        }
        assetLineage.append(assetElement.getNodeName());
    }

    private Document getFieldsDoc(Element assetElement) {
        Element fields = this.getNamedChildren(assetElement, "Fields").get(0);
        Document fieldDoc = null;
        try {
            this.builder = XmlUtil.borrowDocumentBuilder();
            fieldDoc = this.builder.newDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Element fieldsCopy = (Element)fieldDoc.importNode(fields, true);
        fieldDoc.appendChild(fieldsCopy);
        return fieldDoc;
    }

    private Asset getAsset(Element assetElement) {
        if (assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.FILE.name())) {
            File fileAsset = new File();
            this.prepFile(fileAsset, assetElement);
            return fileAsset;
        }
        if (assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.TITLE.name())) {
            Item titleAsset = new Item();
            titleAsset.setType(Item.ItemType.TITLE);
            this.prepAsset(titleAsset, assetElement, true);
            List<Element> fileElements = this.getNamedChildren(assetElement, AssetType.FILE.toString());
            for (int i = 0; i < fileElements.size(); ++i) {
                File fileAsset = new File();
                this.prepFile(fileAsset, fileElements.get(i));
                titleAsset.addChild(fileAsset);
            }
            return titleAsset;
        }
        if (assetElement.getNodeName().equalsIgnoreCase(Group.GroupType.MOVIE.name()) || assetElement.getNodeName().equalsIgnoreCase(Group.GroupType.PREVIEW.name()) || assetElement.getNodeName().equalsIgnoreCase(Group.GroupType.SEASON.name())) {
            Group groupAsset = new Group();
            groupAsset.setType(assetElement.getNodeName().toUpperCase());
            this.prepAsset(groupAsset, assetElement, true);
            List<Element> fileElements = this.getNamedChildren(assetElement, AssetType.FILE.toString());
            for (int i = 0; i < fileElements.size(); ++i) {
                File fileAsset = new File();
                this.prepFile(fileAsset, fileElements.get(i));
                groupAsset.addChild(fileAsset);
            }
            if (assetElement.getNodeName().equalsIgnoreCase(Group.GroupType.SEASON.name())) {
                this.prepChildAssets(groupAsset, assetElement, AssetType.POSTER);
                this.prepChildAssets(groupAsset, assetElement, AssetType.BOXCOVER);
            } else {
                this.prepLogicalClip(groupAsset, assetElement);
            }
            return groupAsset;
        }
        if (assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.POSTER.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.BOXCOVER.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.TRICK.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.BARKER.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.ENCRYPTED.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.MOVIESEGMENTGROUP.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.PREVIEWSEGMENTGROUP.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.DISPLAY.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.GAME.name()) || assetElement.getNodeName().equalsIgnoreCase(Item.ItemType.AUDIO.name())) {
            Item itemAsset = new Item();
            itemAsset.setType(assetElement.getNodeName().toUpperCase());
            this.prepAsset(itemAsset, assetElement, true);
            List<Element> fileElements = this.getNamedChildren(assetElement, AssetType.FILE.toString());
            for (int i = 0; i < fileElements.size(); ++i) {
                File fileAsset = new File();
                this.prepFile(fileAsset, fileElements.get(i));
                itemAsset.addChild(fileAsset);
            }
            return itemAsset;
        }
        return null;
    }

    private void prepLogicalClip(Group groupAsset, Element groupAssetElement) {
        List<Element> lcElements = this.getNamedChildren(groupAssetElement, AssetType.LOGICALCLIP.toString());
        for (int i = 0; i < lcElements.size(); ++i) {
            Item lcAsset = new Item();
            lcAsset.setType(Item.ItemType.LOGICALCLIP);
            List<Element> lcFileElements = this.getNamedChildren(lcElements.get(i), AssetType.FILE.toString());
            if (lcFileElements != null && lcFileElements.size() > 0) {
                for (Element f : lcFileElements) {
                    File lcFileAsset = new File();
                    this.prepFile(lcFileAsset, f);
                    lcAsset.addChild(lcFileAsset);
                }
            }
            this.prepAsset(lcAsset, lcElements.get(i), false);
            groupAsset.addChild(lcAsset);
        }
    }

    private void prepChildAssets(Group groupAsset, Element groupAssetElement, AssetType childAssetType) {
        List<Element> cElements = this.getNamedChildren(groupAssetElement, childAssetType.toString());
        for (int i = 0; i < cElements.size(); ++i) {
            Item cAsset = new Item();
            cAsset.setType(cElements.get(i).getNodeName().toUpperCase());
            List<Element> cFileElements = this.getNamedChildren(cElements.get(i), AssetType.FILE.toString());
            if (cFileElements != null && cFileElements.size() > 0) {
                for (Element f : cFileElements) {
                    File lcFileAsset = new File();
                    this.prepFile(lcFileAsset, f);
                    cAsset.addChild(lcFileAsset);
                }
            }
            this.prepAsset(cAsset, cElements.get(i), false);
            groupAsset.addChild(cAsset);
        }
    }

    private void prepFile(File fileAsset, Element fileElement) {
        NodeList fieldNodeList = fileElement.getElementsByTagName("Fields");
        if (fieldNodeList.getLength() == 1) {
            String fileType = this.getFileType(fieldNodeList.item(0));
            fileAsset.setFileType(FileType.valueOf(fileType));
        }
        this.prepAsset(fileAsset, fileElement, false);
        List<Element> fileElements = this.getNamedChildren(fileElement, AssetType.FILE.toString());
        for (Element f : fileElements) {
            File childFileAsset = new File();
            this.prepFile(childFileAsset, f);
            fileAsset.addChild(childFileAsset);
        }
    }

    private String getFileType(Node item) {
        if (item.getNodeType() != 1) {
            return "";
        }
        NodeList matchingFields = ((Element)item).getElementsByTagName("Text");
        if (matchingFields.getLength() == 1) {
            return matchingFields.item(0).getTextContent();
        }
        return null;
    }

    private List<Element> getNamedChildren(Element element, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node elementChild = children.item(i);
            if (elementChild == null || !elementChild.getNodeName().equals(name)) continue;
            result.add((Element)elementChild);
        }
        return result;
    }
}

