/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.es;

import com.ericsson.neptune.es.CmsTransportClient;
import org.apache.log4j.Logger;

public class TransportClientThread
extends Thread {
    private static Logger LOGGER = Logger.getLogger(TransportClientThread.class);
    private volatile boolean terminate = false;
    private long sleepMs = 300000L;
    private Object sleepLock = new Object();
    private CmsTransportClient client;

    public TransportClientThread(CmsTransportClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.terminate = true;
        Object object = this.sleepLock;
        synchronized (object) {
            this.sleepLock.notify();
        }
    }

    @Override
    public void run() {
        while (!this.terminate) {
            LOGGER.debug((Object)"Updating transport client...");
            this.updateSettings();
            this.updateTransportAddresses();
            this.sleep();
        }
        this.client = null;
        LOGGER.info((Object)"Terminated.");
    }

    private void updateTransportAddresses() {
        try {
            this.client.updateTransportAddresses();
        }
        catch (Exception ex) {
            LOGGER.debug((Object)"Could not update transport addresses.", (Throwable)ex);
        }
    }

    private void updateSettings() {
        try {
            this.client.updateSettings();
        }
        catch (Exception ex) {
            LOGGER.debug((Object)"Could not update settings.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep() {
        try {
            if (this.terminate) {
                return;
            }
            Object object = this.sleepLock;
            synchronized (object) {
                this.sleepLock.wait(this.sleepMs);
            }
        }
        catch (Exception ex) {
            LOGGER.debug((Object)"Exception in sleep().", (Throwable)ex);
        }
    }
}

