/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.authentication.login;

import com.tandbergtv.neptune.usermgmt.external.IUserAuthenticationService;
import com.tandbergtv.neptune.usermgmt.external.UserConfigurationFactory;
import com.tandbergtv.neptune.usermgmt.internal.ConnectionManager;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class NeptuneLoginModule
extends UsernamePasswordLoginModule {
    private static final String NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL = "neptune_sso_oauth2_principal";
    private static final Logger logger = Logger.getLogger((String)NeptuneLoginModule.class.getName());
    private static final String UNAUTHENTICATED_IDENTITY = "_nobody_";
    private static final String AUTH_PROPERTY_PREFIX = "authService.";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"oAuthIntegration"};
    protected String dataSourceName = null;
    protected Map<String, String> authenticationProperties = new HashMap<String, String>();
    protected ConnectionManager connectionManager;
    protected boolean oAuthIntegration = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        HashMap optionsCopy = new HashMap(options);
        optionsCopy.remove("hashAlgorithm");
        super.initialize(subject, callbackHandler, sharedState, optionsCopy);
        if (this.unauthenticatedIdentity == null) {
            try {
                this.unauthenticatedIdentity = this.createIdentity(UNAUTHENTICATED_IDENTITY);
            }
            catch (Exception e) {
                String msg = "Failure creating the required unauthenticated identity: " + e.getMessage();
                logger.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
        for (String key : options.keySet()) {
            if (key == null || !key.startsWith(AUTH_PROPERTY_PREFIX)) continue;
            String name = key.substring(AUTH_PROPERTY_PREFIX.length());
            String value = (String)options.get(key);
            this.authenticationProperties.put(name, value);
        }
        if (options.get("oAuthIntegration") != null) {
            this.oAuthIntegration = Boolean.valueOf((String)options.get("oAuthIntegration"));
        }
        this.dataSourceName = (String)options.get("datasource.name");
        if (this.dataSourceName == null || this.dataSourceName.trim().isEmpty()) {
            this.dataSourceName = "java:/neptune/datasource";
        }
        if (!this.authenticationProperties.containsKey("datasource.name")) {
            this.authenticationProperties.put("datasource.name", this.dataSourceName);
        }
        this.connectionManager = new ConnectionManager(this.dataSourceName);
    }

    public boolean login() throws LoginException {
        try {
            return super.login();
        }
        catch (LoginException e) {
            Throwable error = this.getValidateError();
            if (error instanceof LoginException) {
                throw (LoginException)LoginException.class.cast(error);
            }
            throw e;
        }
    }

    public boolean commit() throws LoginException {
        try {
            boolean bl = super.commit();
            return bl;
        }
        finally {
            this.connectionManager.closeCurrentConnection();
        }
    }

    public boolean abort() throws LoginException {
        try {
            boolean bl = super.abort();
            return bl;
        }
        finally {
            this.connectionManager.closeCurrentConnection();
        }
    }

    protected String getUsersPassword() throws LoginException {
        return "";
    }

    protected boolean validatePassword(String password, String expectedPassword) {
        try {
            String userName = this.getUsername();
            if (userName == null || userName.isEmpty()) {
                throw new FailedLoginException("The user name is invalid.");
            }
            if (this.oAuthIntegration) {
                this.authenticateUserOAuth(userName, password);
            } else {
                this.authenticateUserLegacy(userName, password);
            }
        }
        catch (Throwable error) {
            this.setValidateError(error);
            return false;
        }
        return true;
    }

    private void authenticateUserOAuth(String userName, String password) throws Exception {
        Object ssoPrincipal = null;
        HttpServletRequest request = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
        HttpSession session = request.getSession(false);
        if (session != null) {
            ssoPrincipal = session.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
        }
        if (ssoPrincipal == null) {
            ssoPrincipal = request.getAttribute(NEPTUNE_SSO_OAUTH2_AUTHENTICATION_PRINCIPAL);
            String authHeader = request.getHeader("Authorization");
            String string = authHeader = authHeader == null ? "" : authHeader;
            if (ssoPrincipal == null || authHeader.startsWith("Basic")) {
                this.authenticateUserLegacy(userName, password);
            }
        }
    }

    private void authenticateUserLegacy(String userName, String password) throws Exception {
        UserConfigurationFactory factory;
        if (password == null) {
            throw new FailedLoginException("The password is invalid.");
        }
        UserValidationData validationData = this.getUserValidationData(userName);
        UserConfigurationFactory userConfigurationFactory = factory = validationData.isLocal ? UserConfigurationFactory.getInternalModeFactory() : UserConfigurationFactory.getFactory();
        if (!validationData.isValid && !factory.isLDAPHybridWithExternalRoles()) {
            throw new AccountNotFoundException("The user name is invalid.");
        }
        IUserAuthenticationService service = factory.createUserAuthenticationService();
        if (service == null) {
            throw new RuntimeException("Failed to get instance of user authentication service.");
        }
        service.setProperties(this.authenticationProperties);
        service.authenticateUser(userName, password, validationData.externalKey);
    }

    private UserValidationData getUserValidationData(String userName) {
        boolean isValid = false;
        boolean isLocal = false;
        String externalKey = null;
        PreparedStatement statement = null;
        try {
            Connection connection = this.connectionManager.getCurrentConnection();
            String query = "SELECT PASSWORD, EXTERNALKEY FROM CMS_USER WHERE USERNAME = ? and active = CAST(1 AS character varying)";
            statement = connection.prepareStatement(query);
            statement.setString(1, this.getUsername());
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                isValid = true;
                String password = resultSet.getString(1);
                externalKey = resultSet.getString(2);
                isLocal = externalKey == null && password != null && !password.isEmpty();
            }
        }
        catch (SQLException e) {
            try {
                String msg = "Failed to determine if user name exists in the local database: " + e.getLocalizedMessage();
                throw new RuntimeException(msg, e);
            }
            catch (Throwable throwable) {
                this.connectionManager.closeSQLStatement(statement);
                throw throwable;
            }
        }
        this.connectionManager.closeSQLStatement((Statement)statement);
        return new UserValidationData(isValid, isLocal, externalKey);
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup group = new SimpleGroup("Roles");
        if (!this.getUnauthenticatedIdentity().equals(this.getIdentity())) {
            PreparedStatement statement = null;
            try {
                Connection connection = this.connectionManager.getCurrentConnection();
                String query = "SELECT M.MODULENAME || '_' || P.PERMISSIONNAME AS ROLE_NAME FROM CMS_USER U, CMS_USERROLES UR, CMS_ROLEPERMISSIONS RP, CMS_PERMISSION P, CMS_MODULE M WHERE U.USERID = UR.USERID AND UR.ROLEID = RP.ROLEID AND RP.PERMISSIONID = P.PERMISSIONID AND P.MODULEID = M.MODULEID AND U.USERNAME = ?";
                statement = connection.prepareStatement(query);
                statement.setString(1, this.getUsername());
                ResultSet resultSet = statement.executeQuery();
                HashSet<String> roles = new HashSet<String>();
                while (resultSet.next()) {
                    String role = resultSet.getString(1);
                    roles.add(role);
                }
                for (String role : roles) {
                    group.addMember(super.createIdentity(role));
                }
            }
            catch (Throwable e) {
                try {
                    String msg = "Failed to get roles for user[" + this.getUsername() + "]: " + e.getLocalizedMessage();
                    FailedLoginException error = new FailedLoginException(msg);
                    error.initCause(e);
                    throw error;
                }
                catch (Throwable throwable) {
                    this.connectionManager.closeSQLStatement(statement);
                    throw throwable;
                }
            }
            this.connectionManager.closeSQLStatement((Statement)statement);
        }
        return new Group[]{group};
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    private static final class UserValidationData {
        final boolean isValid;
        final boolean isLocal;
        final String externalKey;

        UserValidationData(boolean isValid, boolean isLocal, String externalKey) {
            this.isValid = isValid;
            this.isLocal = isLocal;
            this.externalKey = externalKey;
        }
    }
}

