package com.tandbergtv.neptune.ui.realm.client.settings.view;

import java.util.List;

import com.tandbergtv.neptune.ui.realm.client.settings.service.UiLocalizedString;

public class LocalizedSettingUtil {

    public static String DEFAULT_LANG = "en";

    public static String toLocalizedString(List<UiLocalizedString> lss) {
        String resultStr = "";

        UiLocalizedString localizedString = null;
        for (UiLocalizedString ls : lss) {
            if (DEFAULT_LANG.equals(ls.getLang())) {
                localizedString = ls;
                break;
            }
        }

        if (localizedString == null) {
            if (!lss.isEmpty()) {
                localizedString = lss.get(0);
            }
        }

        if (localizedString != null) {
            resultStr = localizedString.getValue();
        }

        return resultStr.trim();
    }
}
