package com.tandbergtv.neptune.widgettoolkit.client.remote;

import java.util.logging.Logger;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.widgettoolkit.client.util.StringUtils;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

public class RPCServiceCheckHandler {
	
	private static final int MAX_RETRY_TIME = 1000 * 60 * 30;
	
	public static final String SESSION_TIMEOUT_FLAG = "_ste=0";


	private Logger logger = Logger.getLogger("RPCServiceCheckHandler");

	private int serviceCheckSleepTime = 5000;

	private long totalRetryTime = serviceCheckSleepTime;

	private Timer serviceCheckTimer;

	private static int serviceUnhandleRPCCounter = 0;
	
	private BusyIndicator busyIndicator;

	private String serviceUrl;
	
	
	
	public static int getServiceUnhandleRPCCounter() {
		return serviceUnhandleRPCCounter;
	}
	
	public static int inCrementRPCCounter() {
		return serviceUnhandleRPCCounter ++;
	}
	

	public void handleUnavailableService(String url) {
		this.serviceUrl = url;
		handleUnavailableService();
	}
	
	public void handleUnavailableService() {
		if (serviceUnhandleRPCCounter < 2) {
			inCrementRPCCounter();
			retryingCheckUnavailableService();
		}
	}

	private void retryingCheckUnavailableService() {

		/**
		 * avoid create multiple instances;
		 */
		closeAlertWidget();

		serviceCheckTimer = new Timer() {

			

			public void run() {
				totalRetryTime += serviceCheckSleepTime;
				
				if (totalRetryTime > MAX_RETRY_TIME) {
					logger.info("Beyond the max try time: totalRetryTime>" + totalRetryTime + ":MAX_RETRY_TIME"); 
					closeAlertWidget();
					
					/**
					 * Generate 503 page from Haproxy.
					 */
					Window.Location.reload();
					return;
				}
				
				/**
				 * we need to add a random key in url to avoid the browser cache, it happened in IE 11.
				 */
				
				String checkUrl = getServiceURL() + getConcatSymbol(Window.Location.getHref())
						+ "rsk=" + System.currentTimeMillis();
				
				logger.info("checkUrl:" + checkUrl);
				
				RequestBuilder rb = new RequestBuilder(RequestBuilder.GET, checkUrl);

				try {
					rb.sendRequest(null, addResponseCallback());
				} catch (RequestException e) { // NOSONAR
					logger.info("RequestException : " + e.getMessage());
				}
			}
			
		};

		showServiceUnavailableAlert();
		serviceCheckTimer.scheduleRepeating(serviceCheckSleepTime);
	}
	
	protected String getServiceURL() {
		return serviceUrl == null ? Window.Location.getHref() : serviceUrl;
	}

	/**
	 * reload the current browser to trigger the re-login event or refresh event.
	 */
	public void reloadBrowser() {
		Cookies.setCookie("_ste", "0", null, null , "/", false);
		
		Window.Location.reload();
	}
	
	private void closeAlertWidget() {
		if (serviceCheckTimer != null) {
			serviceCheckTimer.cancel();
		}
		
		if (busyIndicator != null) {
			busyIndicator.hide();
		}
	}

	private RequestCallback addResponseCallback() {
		return new RequestCallback() {

			@Override
			public void onResponseReceived(Request request, Response response) {
				logger.info("Get service check response:" + response.getStatusCode());

				if (response.getStatusCode() == 200) {
					closeAlertWidget();
					reloadBrowser();
					return;
				}
				showServiceUnavailableAlert();
			}

			@Override
			public void onError(Request request, Throwable exception) {
				logger.severe("rbq erro:" + exception.getMessage());
				showServiceUnavailableAlert();
			}
		};
	}
	private String getConcatSymbol(String href) {
		return StringUtils.trimToEmpty(href).contains("?") ?  "&" : "?";
	}
	
	private void showServiceUnavailableAlert() {
		String msg = "Service is not available. Please wait...";
		if (BusyIndicator.resetAlertMsgForFirstLiveIndicator(msg)) {
			return;
		} 
		
		if (busyIndicator == null) {
			logger.warning("Create new BusyIndicator...");
			busyIndicator = new BusyIndicator();
			busyIndicator.setAlertMessage(msg).center();
			
		} else {
			busyIndicator.show();
		}
	}

}
