package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.google.gwt.dom.client.BodyElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.HeadingElement;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.tandbergtv.neptune.widgettoolkit.client.remote.RPCServiceCheckHandler;
import com.tandbergtv.neptune.widgettoolkit.client.util.StringUtils;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.IFrameContainer;

public class IFrameServiceCheckLoadEvent implements LoadHandler {
	private RPCServiceCheckHandler handler = new RPCServiceCheckHandler();
	private IFrameContainer iframeContainer;

	public IFrameServiceCheckLoadEvent(IFrameContainer iframeContainer) {
		super();
		this.iframeContainer = iframeContainer;
	}

	@Override
	public void onLoad(LoadEvent event) {
		if (iframeContainer.getIFrameWidget() == null) {
			return;
		}

		BodyElement body = iframeContainer.getIFrameElement().getContentDocument().getBody();
		String content = StringUtils.trimToEmpty(body.getInnerHTML());
		String title = StringUtils.trimToEmpty(getPossibleErrorTitle(body));

		/**
		 * We cant' use response code, have to use tricky way to check here.
		 */

		if (content.length() < 500 && title.length() < 500
				&& (title.contains("503 Service") || title.contains("Status 404"))) {

			body.setInnerHTML("");
			handler.handleUnavailableService(iframeContainer.getIFrameWidget().getUrl());
		}
	}

	private String getPossibleErrorTitle(BodyElement body) {
		NodeList<Element> h1Tag = body.getElementsByTagName(HeadingElement.TAG_H1);
		Element title = h1Tag != null && h1Tag.getLength() > 0 ? h1Tag.getItem(0) : body;
		return title.getInnerText();
	}

	
}
