/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.neptune.componentmgr.ejb;

import com.ericsson.neptune.componentmgr.ejb.ComponentTypeModuleProvider;
import com.ericsson.neptune.componentmgr.service.IComponentManager;
import com.ericsson.neptune.componentmgr.service.IComponentSynchronizer;
import com.ericsson.neptune.distributed.component.jaxb.ComponentType;
import com.ericsson.neptune.distributed.component.jaxb.ObjectFactory;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tandbergtv.neptune.authorization.service.IInternalModuleSynchronizer;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.realm.persist.Component;
import com.tandbergtv.neptune.validation.ValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

@Stateless
public class ComponentSynchronizer
implements IComponentSynchronizer {
    private static final Logger logger = Logger.getLogger(ComponentSynchronizer.class);
    @EJB
    private IComponentManager componentManager;
    @EJB
    private IConfigurationService configurationService;
    @EJB
    private IInternalModuleSynchronizer moduleSyncService;
    @EJB
    private ISettingsService settingsService;
    @EJB
    private ILicenseManager licenseManager;
    private static final String REGISTRATION_SERVICE_LOCATOR = "/component";
    private static final String REMOTE_COMPONENTS_SETTING = "com.ericsson.cms.neptune.remotecomponents";
    private volatile int connectionTimeout = -1;
    Boolean isRCSOnly = null;
    private Map<String, ComponentType> registeredRemoteComponents = Maps.newConcurrentMap();

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void synchronize() {
        this.initConnectionTimeout();
        this.moduleSyncService.synchronize();
        List<Component> components = this.getComponents();
        this.registeredRemoteComponents.clear();
        if (this.isRCSOnly == null) {
            this.isRCSOnly = Boolean.FALSE;
            try {
                if (Boolean.parseBoolean(this.licenseManager.getProperty("IsRCSOnly"))) {
                    this.isRCSOnly = Boolean.TRUE;
                }
            }
            catch (InvalidLicenseException e) {
                logger.error((Object)"Could not read license...assuming that IsRCSOnly is false", (Throwable)e);
            }
        }
        for (Component component : components) {
            ComponentType next = this.getRegistrationData(component);
            if (next == null) continue;
            logger.debug((Object)("Synchronizing component[" + component.getName() + "]"));
            if (this.isRCSOnly.booleanValue() && !"EPG".equalsIgnoreCase(component.getName())) {
                logger.warn((Object)("This system is licensed for 'RCS Only' deployment, " + component.getName() + " would not be synchronized."));
                this.deleteComponentRegistrationData(Arrays.asList(component.getName()));
                continue;
            }
            this.moduleSyncService.synchronize(component.getId(), (IModuleProvider)new ComponentTypeModuleProvider(next));
        }
        this.moduleSyncService.updateAdministratorRoles();
        this.moduleSyncService.updateServicesUserRoles();
    }

    private void initConnectionTimeout() {
        if (this.connectionTimeout > 0) {
            return;
        }
        try {
            this.connectionTimeout = Integer.parseInt((String)this.settingsService.getProperties(REMOTE_COMPONENTS_SETTING).get("connection_timeout"));
        }
        catch (Exception ex) {
            this.connectionTimeout = 15000;
            logger.error((Object)("Unable to parse setting com.ericsson.cms.neptune.remotecomponents. Using default value " + this.connectionTimeout), (Throwable)ex);
        }
    }

    public boolean updateRegistration(String componentName) {
        Component component = this.componentManager.getComponent(componentName);
        if (component == null) {
            logger.error((Object)("Cannot update registration for component - No component exists with name " + componentName));
            return false;
        }
        ComponentType componentType = this.getRegistrationData(component);
        if (componentType != null) {
            this.moduleSyncService.synchronize(component.getId(), (IModuleProvider)new ComponentTypeModuleProvider(componentType));
            this.moduleSyncService.updateAdministratorRoles();
            this.moduleSyncService.updateServicesUserRoles();
            return true;
        }
        return false;
    }

    public List<ComponentType> getComponentRegistrationData() {
        ArrayList types = Lists.newArrayList(this.registeredRemoteComponents.values());
        Collections.sort(types, (p1, p2) -> p1.getDisplayName().compareTo(p2.getDisplayName()));
        return types;
    }

    public void deleteComponentRegistrationData(List<String> componentNames) {
        for (String name : componentNames) {
            this.registeredRemoteComponents.remove(name);
        }
    }

    private String getRegistrationUrl(Component component) {
        String baseURL = component.getBaseURL();
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        return baseURL + component.getName() + REGISTRATION_SERVICE_LOCATOR;
    }

    private List<Component> getComponents() {
        return this.componentManager.getComponents();
    }

    private Unmarshaller getComponentTypeUnmarshaller() throws JAXBException {
        Class<ObjectFactory> factoryClass = ObjectFactory.class;
        JAXBContext jaxbContext = JAXBContext.newInstance((String)factoryClass.getPackage().getName(), (ClassLoader)factoryClass.getClassLoader());
        return jaxbContext.createUnmarshaller();
    }

    private ComponentType unmarshallComponentType(String xmlResponse) throws JAXBException {
        JAXBElement element = (JAXBElement)this.getComponentTypeUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(xmlResponse)));
        return (ComponentType)element.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentType getRegistrationData(Component component) {
        ComponentType componentType;
        block8: {
            componentType = null;
            component.setStatusId(IComponentManager.ComponentStatusType.INACTIVE.id());
            String url = this.getRegistrationUrl(component);
            try {
                this.addGlobalSSLSetting(url);
                HttpURLConnection conn = this.createConnection(url);
                conn.connect();
                if (conn.getResponseCode() == 200) {
                    String xmlResponse = IOUtils.toString((InputStream)conn.getInputStream());
                    componentType = this.unmarshallComponentType(xmlResponse);
                    component.setStatusId(IComponentManager.ComponentStatusType.ACTIVE.id());
                    component.setLastSuccessfulSynchTimestamp(new Date());
                    this.registeredRemoteComponents.put(component.getName(), componentType);
                    logger.debug((Object)("Component [" + component.getName() + "] Started."));
                    break block8;
                }
                logger.error((Object)("Component [" + component.getName() + "] registration response Error: " + conn.getResponseCode() + ", " + conn.getResponseMessage()));
            }
            catch (JAXBException e) {
                logger.error((Object)("Could not parse registration data :" + e.getLocalizedMessage()), (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)("Component registration failed for " + component.getName()), (Throwable)e);
            }
        }
        try {
            this.componentManager.update(component);
        }
        catch (ValidationException e) {
            String message = "Failed to set status for Component[" + component.getName() + "]. " + e.getLocalizedMessage();
            logger.error((Object)message, (Throwable)e);
        }
        return componentType;
    }

    private HttpURLConnection createConnection(String url) throws IOException {
        URL reqUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)reqUrl.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "application/text");
        conn.setConnectTimeout(this.connectionTimeout);
        conn.setReadTimeout(this.connectionTimeout);
        return conn;
    }

    private void addGlobalSSLSetting(String url) throws NoSuchAlgorithmException, KeyManagementException {
        if (url.startsWith("https://")) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
    }
}

