/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.ejb;

import com.tandbergtv.neptune.configuration.entity.ProductInfo;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.configuration.service.IConfigurationServiceRemote;
import com.tandbergtv.neptune.configuration.service.ILifecycleConfigurationService;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.util.PropertyFileReader;
import com.tandbergtv.neptune.validation.SettingValidationException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Singleton(name="Neptune:service=com.tandbergtv.neptune.configuration.service.IConfigurationService")
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
@Remote(value={IConfigurationServiceRemote.class})
@Local(value={IConfigurationService.class})
@Startup
public class ConfigurationService
implements ILifecycleConfigurationService,
IConfigurationService,
IConfigurationServiceRemote {
    private String confFolderLocation;
    private static final String INSTALL_FOLDER_PROPERTY = "com.tandbergtv.cms.product.dir";
    private static final String CONFIG_FOLDER_RELATIVE_PATH = "conf";
    private static final String PRODUCT_FILE = "product.properties";
    private static final Logger logger = Logger.getLogger(ConfigurationService.class);
    @EJB
    private ILicenseManager licenseManager;
    @EJB
    private ISettingsService settingsService;

    @Override
    @PostConstruct
    public void start() throws Exception {
        File configFolder = new File(System.getProperty(INSTALL_FOLDER_PROPERTY), CONFIG_FOLDER_RELATIVE_PATH);
        this.confFolderLocation = configFolder.getAbsolutePath();
        logger.debug((Object)("confFolderLocation=" + this.confFolderLocation));
        this.settingsService.loadSettings(this.confFolderLocation);
    }

    public File getFile(String relativeFolderPath, String filename) {
        if (relativeFolderPath != null && !relativeFolderPath.equals("")) {
            File folderLocation = new File(this.confFolderLocation, relativeFolderPath);
            logger.debug((Object)("final folderLocation=" + folderLocation.getAbsolutePath()));
            return new File(folderLocation, filename);
        }
        return new File(this.confFolderLocation, filename);
    }

    public String getInstallDirectory() {
        return System.getProperty(INSTALL_FOLDER_PROPERTY);
    }

    public File getFile(String relativeFilePath) {
        return new File(this.confFolderLocation, relativeFilePath);
    }

    public ProductInfo getProductInfo() {
        ProductInfo productInfo;
        File productFile = new File(this.getInstallDirectory(), PRODUCT_FILE);
        if (productFile.exists()) {
            Map properties = PropertyFileReader.readProperties((File)productFile);
            productInfo = new ProductInfo(properties);
            productInfo.setLicenseValid(this.validateLicense());
        } else {
            logger.warn((Object)("[Configuration Error] product.properties file is not present in " + productFile.getParent()));
            productInfo = new ProductInfo();
            productInfo.setLicenseValid(true);
        }
        this.logSoftwareInfo(productInfo);
        return productInfo;
    }

    private boolean validateLicense() {
        boolean licenseValid = true;
        try {
            String expirationDateStr = this.licenseManager.getProperty("expirationDate");
            if (StringUtils.isNotEmpty((String)expirationDateStr)) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date licenseExpirationDate = dateFormat.parse(this.licenseManager.getProperty("expirationDate"));
                licenseValid = licenseExpirationDate.after(new Date());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Invalid license", (Throwable)e);
            licenseValid = false;
        }
        return licenseValid;
    }

    private void logSoftwareInfo(ProductInfo productInfo) {
        logger.info((Object)("[software version] " + this.removeHTMLTags(productInfo.getProductTitle()) + " " + productInfo.getProductVersion()));
    }

    private String removeHTMLTags(String str) {
        return str.replaceAll("\\<.*&?>", "");
    }

    public Map<String, String> getProperties(String settingsPath) {
        return this.settingsService.getProperties(settingsPath);
    }

    public void saveSettings(String groupPath, Map<String, String> values) throws SettingValidationException {
        this.settingsService.saveSettings(groupPath, values);
    }

    public String getAllSettingDefinitionsAsJSON() {
        return this.settingsService.getAllSettingDefinitionsAsJSON();
    }

    public String getPropertiesAsJSON(String settingsPath) {
        return this.settingsService.getPropertiesAsJSON(settingsPath);
    }

    public void importAllSettings(Map<String, Map<String, String>> settings, boolean ignoreValidation) throws SettingValidationException {
        this.settingsService.importAllSettings(settings, ignoreValidation);
    }

    public void saveSettings(String groupPath, Map<String, String> values, boolean ignoreValidation) throws SettingValidationException {
        this.settingsService.saveSettings(groupPath, values, ignoreValidation);
    }

    public void saveSingleSetting(String groupPath, String setting, String value) throws SettingValidationException {
        this.settingsService.saveSingleSetting(groupPath, setting, value);
    }
}

