/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.realm.conf;

import com.google.common.base.Splitter;
import com.tandbergtv.neptune.realm.conf.IRealmConfigurationService;
import com.tandbergtv.neptune.realm.conf.RealmConfigurationException;
import com.tandbergtv.neptune.realm.conf.RealmConfigurationReader;
import com.tandbergtv.neptune.usermgmt.external.UserConfigurationFactory;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@DependsOn(value={"Neptune:service=com.tandbergtv.neptune.configuration.service.IConfigurationService"})
@Singleton(name="Neptune:service=com.tandbergtv.neptune.realm.conf.IRealmConfigurationService")
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class RealmConfigurationService
implements IRealmConfigurationService {
    private static final Logger logger = Logger.getLogger(RealmConfigurationService.class);
    private RealmConfigurationReader configurationReader = new RealmConfigurationReader();
    private Properties configuration = null;
    private static final String PROPS = "./neptune_realm.properties";

    @Override
    @PostConstruct
    public void start() throws Exception {
        try {
            this.configuration = this.configurationReader.readRealmConfiguration(PROPS);
        }
        catch (Exception e) {
            String msg = "[Configuration Error] ./neptune_realm.properties is missing, error: " + e.getLocalizedMessage();
            throw new RealmConfigurationException(msg, e);
        }
        try {
            UserConfigurationFactory.getFactory();
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            UserConfigurationFactory.getInternalModeFactory();
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public Properties getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getAdministratorUserName() throws RealmConfigurationException {
        String userName = this.configuration.getProperty("NeptuneRealm.AdministratorUserName");
        return StringUtils.trimToNull((String)userName);
    }

    @Override
    public List<String> getAdministratorRoleNames() throws RealmConfigurationException {
        String value = this.configuration.getProperty("NeptuneRealm.AdministratorRoleNames");
        return Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)value);
    }

    @Override
    public String getServicesRoleName() {
        return StringUtils.trimToNull((String)this.configuration.getProperty("NeptuneRealm.ServicesRoleName"));
    }
}

