/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
public class CSSFontFaceRule
extends CSSRule {
    private static final Pattern REPLACEMENT_1 = Pattern.compile("font-family: ([^;]*);");
    private static final Pattern REPLACEMENT_2 = Pattern.compile("src: url\\(([^;]*)\\);");

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME)})
    public CSSFontFaceRule() {
    }

    protected CSSFontFaceRule(CSSStyleSheet stylesheet, org.w3c.dom.css.CSSFontFaceRule rule) {
        super(stylesheet, rule);
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public short getType() {
        return 5;
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public String getCssText() {
        String cssText = super.getCssText();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.CSS_FONTFACERULE_CSSTEXT_CRLF)) {
            cssText = StringUtils.replace((String)cssText, (String)"{", (String)"{\r\n\t");
            cssText = StringUtils.replace((String)cssText, (String)"}", (String)";\r\n}\r\n");
            cssText = StringUtils.replace((String)cssText, (String)"; ", (String)";\r\n\t");
        } else {
            cssText = StringUtils.replace((String)cssText, (String)"{", (String)"{\n  ");
            cssText = StringUtils.replace((String)cssText, (String)"}", (String)";\n}");
            cssText = StringUtils.replace((String)cssText, (String)"; ", (String)";\n  ");
            cssText = REPLACEMENT_1.matcher(cssText).replaceFirst("font-family: \"$1\";");
            cssText = REPLACEMENT_2.matcher(cssText).replaceFirst("src: url(\"$1\");");
        }
        return cssText;
    }
}

