/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.dom.TreeWalker;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
public class NodeIterator
extends SimpleScriptable {
    private Node root_;
    private long whatToShow_;
    private Scriptable filter_;
    private Node referenceNode_;
    private boolean pointerBeforeReferenceNode_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public NodeIterator() {
    }

    @JsxGetter
    public Node getRoot() {
        return this.root_;
    }

    public double getWhatToShow() {
        return this.whatToShow_;
    }

    public Scriptable getFilter() {
        return this.filter_;
    }

    public Node getReferenceNode() {
        return this.referenceNode_;
    }

    public boolean isPointerBeforeReferenceNode() {
        return this.pointerBeforeReferenceNode_;
    }

    public NodeIterator(Node root, double whatToShow, Scriptable filter) {
        this.root_ = root;
        this.referenceNode_ = root;
        this.whatToShow_ = Double.valueOf(whatToShow).longValue();
        this.filter_ = filter;
        this.pointerBeforeReferenceNode_ = true;
    }

    @JsxFunction
    public void detach() {
    }

    @JsxFunction
    public Node nextNode() {
        return this.traverse(true);
    }

    @JsxFunction
    public Node previousNode() {
        return this.traverse(false);
    }

    private Node traverse(boolean next) {
        Node node = this.referenceNode_;
        boolean beforeNode = this.pointerBeforeReferenceNode_;
        do {
            Node follow;
            Node parent;
            if (next) {
                if (beforeNode) {
                    beforeNode = false;
                    continue;
                }
                Node leftChild = this.getChild(node, true);
                if (leftChild != null) {
                    node = leftChild;
                    continue;
                }
                Node rightSibling = this.getSibling(node, false);
                if (rightSibling != null) {
                    node = rightSibling;
                    continue;
                }
                node = this.getFirstUncleNode(node);
                continue;
            }
            if (!beforeNode) {
                beforeNode = true;
                continue;
            }
            Node left = this.getSibling(node, true);
            if (left == null && (parent = node.getParent()) == null) {
                node = null;
            }
            if ((follow = left) != null) {
                Node toFollow;
                while (follow.hasChildNodes() && (toFollow = this.getChild(follow, false)) != null) {
                    follow = toFollow;
                }
            }
            node = follow;
        } while (node != null && (!this.isNodeVisible(node) || !this.isAccepted(node)));
        this.referenceNode_ = node;
        this.pointerBeforeReferenceNode_ = beforeNode;
        return node;
    }

    private boolean isNodeVisible(Node node) {
        return (this.whatToShow_ & (long)TreeWalker.getFlagForNode(node)) != 0L;
    }

    private boolean isAccepted(Node node) {
        Object acceptNode;
        if (this.filter_ == null) {
            return true;
        }
        Function function = null;
        if (this.filter_ instanceof Function) {
            function = (Function)this.filter_;
        }
        if ((acceptNode = this.filter_.get("acceptNode", this.filter_)) instanceof Function) {
            function = (Function)acceptNode;
        }
        if (function != null) {
            double value = Context.toNumber((Object)function.call(Context.getCurrentContext(), this.getParentScope(), (Scriptable)this, new Object[]{node}));
            return value == 1.0;
        }
        return true;
    }

    private Node getFirstUncleNode(Node node) {
        if (node == this.root_ || node == null) {
            return null;
        }
        Node parent = node.getParent();
        if (parent == null) {
            return null;
        }
        Node uncle = this.getSibling(parent, false);
        if (uncle != null) {
            return uncle;
        }
        return this.getFirstUncleNode(parent);
    }

    private Node getChild(Node node, boolean lookLeft) {
        if (node == null) {
            return null;
        }
        Node child = lookLeft ? node.getFirstChild() : node.getLastChild();
        return child;
    }

    private Node getSibling(Node node, boolean lookLeft) {
        if (node == null) {
            return null;
        }
        Node sibling = lookLeft ? node.getPreviousSibling() : node.getNextSibling();
        return sibling;
    }
}

