/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMException;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.svg.SvgElement;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.ProcessingInstruction;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
public class XMLDocument
extends Document {
    private static final Log LOG = LogFactory.getLog(XMLDocument.class);
    private boolean async_ = true;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public XMLDocument() {
        this(null);
    }

    public XMLDocument(WebWindow enclosingWindow) {
        if (enclosingWindow != null) {
            try {
                XmlPage page = new XmlPage((WebResponse)null, enclosingWindow);
                this.setDomNode(page);
            }
            catch (IOException e) {
                throw Context.reportRuntimeError((String)("IOException: " + e));
            }
        }
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setAsync(boolean async) {
        this.async_ = async;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public boolean getAsync() {
        return this.async_;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public boolean load(String xmlSource) {
        if (this.async_ && LOG.isDebugEnabled()) {
            LOG.debug((Object)"XMLDocument.load(): 'async' is true, currently treated as false.");
        }
        try {
            HtmlPage htmlPage = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
            WebRequest request = new WebRequest(htmlPage.getFullyQualifiedUrl(xmlSource));
            WebResponse webResponse = this.getWindow().getWebWindow().getWebClient().loadWebResponse(request);
            XmlPage page = new XmlPage(webResponse, this.getWindow().getWebWindow(), false);
            this.setDomNode(page);
            return true;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error parsing XML from '" + xmlSource + "'"), (Throwable)e);
            }
            return false;
        }
    }

    public boolean loadXML(String strXML) {
        WebWindow webWindow = this.getWindow().getWebWindow();
        try {
            if (StringUtils.isEmpty((CharSequence)strXML) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMPARSER_EMPTY_STRING_IS_ERROR)) {
                throw new IOException("Error parsing XML '" + strXML + "'");
            }
            StringWebResponse webResponse = new StringWebResponse(strXML, webWindow.getEnclosedPage().getUrl());
            XmlPage page = new XmlPage(webResponse, webWindow, false);
            this.setDomNode(page);
            return true;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error parsing XML\n" + strXML), (Throwable)e);
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMPARSER_EXCEPTION_ON_ERROR)) {
                throw this.asJavaScriptException(new DOMException("Syntax Error", 12));
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMPARSER_PARSERERROR_ON_ERROR)) {
                try {
                    XmlPage page = this.createParserErrorXmlPage("Syntax Error", webWindow);
                    this.setDomNode(page);
                }
                catch (IOException eI) {
                    LOG.error((Object)"Could not handle ParserError", (Throwable)e);
                }
            }
            return false;
        }
    }

    private XmlPage createParserErrorXmlPage(String message, WebWindow webWindow) throws IOException {
        String xml = "<parsererror xmlns=\"http://www.mozilla.org/newlayout/xml/parsererror.xml\">\n" + message + "\n" + "<sourcetext></sourcetext>\n" + "</parsererror>";
        StringWebResponse webResponse = new StringWebResponse(xml, webWindow.getEnclosedPage().getUrl());
        return new XmlPage(webResponse, webWindow, false);
    }

    @Override
    public SimpleScriptable makeScriptableFor(DomNode domNode) {
        SimpleScriptable scriptable;
        if (domNode instanceof DomElement && !(domNode instanceof HtmlElement)) {
            if (domNode instanceof SvgElement) {
                Class<? extends SimpleScriptable> javaScriptClass = this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine().getJavaScriptClass(domNode.getClass());
                try {
                    scriptable = javaScriptClass.newInstance();
                }
                catch (Exception e) {
                    throw Context.throwAsScriptRuntimeEx((Throwable)e);
                }
            } else {
                scriptable = new Element();
            }
        } else if (domNode instanceof DomAttr) {
            scriptable = new Attr();
        } else {
            return super.makeScriptableFor(domNode);
        }
        scriptable.setPrototype(this.getPrototype(scriptable.getClass()));
        scriptable.setParentScope(this.getParentScope());
        scriptable.setDomNode(domNode);
        return scriptable;
    }

    @Override
    protected void initParentScope(DomNode domNode, SimpleScriptable scriptable) {
        scriptable.setParentScope(this.getParentScope());
    }

    @Override
    @JsxFunction
    public HTMLCollection getElementsByTagName(final String tagName) {
        DomNode firstChild = this.getDomNodeOrDie().getFirstChild();
        if (firstChild == null) {
            return HTMLCollection.emptyCollection(this.getWindow());
        }
        HTMLCollection collection = new HTMLCollection(this.getDomNodeOrDie(), false, "XMLDocument.getElementsByTagName"){

            @Override
            protected boolean isMatching(DomNode node) {
                return node.getNodeName().equals(tagName);
            }
        };
        return collection;
    }

    @JsxFunction
    public Object getElementById(String id) {
        DomNode domNode = this.getDomNodeOrDie();
        Object domElement = domNode.getFirstByXPath("//*[@id = \"" + id + "\"]");
        if (domElement != null) {
            if (!(domNode instanceof XmlPage) || domElement instanceof HtmlElement || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_XML_GET_ELEMENT_BY_ID__ANY_ELEMENT)) {
                return ((DomElement)domElement).getScriptObject();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getElementById(" + id + "): no HTML DOM node found with this ID"));
            }
        }
        return null;
    }

    @JsxFunction
    public Object createProcessingInstruction(String target, String data) {
        ProcessingInstruction node = this.getPage().createProcessingInstruction(target, data);
        return this.getScriptableFor(node);
    }

    @JsxFunction
    public Object createCDATASection(String data) {
        CDATASection node = this.getPage().createCDATASection(data);
        return this.getScriptableFor(node);
    }
}

