/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.automation.login;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class LoginTest {
    private static final String USERNAME = "admin";
    private static final String PASSWORD = "admin";
    private WebClient webClient;
    private MyHtmlUnitDriver htmlUnitDriver;
    private String portalUrl;
    private String userPortalUrl;
    private boolean runAPP = true;
    private boolean runPT = true;
    private int timeoutSecs = 30;
    private boolean debug = false;

    public LoginTest(String host) {
        this(host, "30");
    }

    public LoginTest(String host, String strTimeout) {
        this(host, strTimeout, "");
    }

    public LoginTest(String host, String strTimeout, String node) {
        if (node.equals("app") || node.equals("APP")) {
            this.portalUrl = "https://" + host + ":8443/portal";
            this.runPT = false;
        } else if (node.equals("pt") || node.equals("PT")) {
            this.userPortalUrl = "https://" + host + ":8443/userportal";
            this.runAPP = false;
        } else {
            this.portalUrl = "https://" + host + ":8443/portal";
            this.userPortalUrl = "https://" + host + ":16443/userportal";
        }
        Logger.getLogger("com.gargoylesoftware").setLevel(Level.OFF);
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        try {
            this.timeoutSecs = Integer.parseInt(strTimeout);
        }
        catch (Exception exception) {
            this.timeoutSecs = 30;
        }
    }

    public LoginTest(String host, String strTimeout, String node, boolean dbg) {
        this(host, strTimeout, node);
        this.debug = dbg;
    }

    private void setLoginAlertHandler() {
        this.webClient.setAlertHandler(new AlertHandler(){

            public void handleAlert(Page page, String message) {
                LoginTest.info(String.format("Alerts @ Page: %s, Alert: %s", page, message));
                if (message.toLowerCase().contains("fail")) {
                    LoginTest.info("Word \"fail\" present in the alert");
                    LoginTest.this.exit(1);
                }
            }
        });
    }

    private void setLogoutAlertHandler() {
        this.webClient.setAlertHandler(new AlertHandler(){

            public void handleAlert(Page page, String message) {
                LoginTest.info(String.format("Alerts @ Page: %s, Alert: %s", page, message));
                if (!message.contains("Logged off successfully.")) {
                    LoginTest.info("Could not logout");
                    LoginTest.this.exit(1);
                }
            }
        });
    }

    private void cmsLoginForm(HtmlPage page) throws Exception {
        String usernameXPath = "//input[@name='j_username']";
        String passwordXPath = "//input[@name='j_password']";
        String loginXPath = "//button[@type='submit']";
        HtmlTextInput usernameField = (HtmlTextInput)page.getFirstByXPath(usernameXPath);
        HtmlPasswordInput passwordField = (HtmlPasswordInput)page.getFirstByXPath(passwordXPath);
        HtmlButton loginButton = (HtmlButton)page.getFirstByXPath(loginXPath);
        if (usernameField == null) {
            LoginTest.info("User Name field not found in HTML. Probably login page didn't load.");
            this.exit(1);
        }
        if (passwordField == null) {
            LoginTest.info("Password field not found in HTML. Probably login page didn't load.");
            this.exit(1);
        }
        usernameField.setValueAttribute("admin");
        passwordField.setValueAttribute("admin");
        if (loginButton == null) {
            LoginTest.info("Login button not found in HTML. Probably login page didn't load.");
            this.exit(1);
        } else {
            LoginTest.info("Login page obtained. Attempting login");
            loginButton.click();
        }
    }

    private void userPortalLoginForm(HtmlPage page) throws Exception {
        String usernameXPath = "//input[@name='j_username']";
        String passwordXPath = "//input[@name='j_password']";
        String userPortalLoginXPath = "//input[@type='submit']";
        HtmlTextInput usernameField = (HtmlTextInput)page.getFirstByXPath(usernameXPath);
        HtmlPasswordInput passwordField = (HtmlPasswordInput)page.getFirstByXPath(passwordXPath);
        HtmlSubmitInput portalLogin = (HtmlSubmitInput)page.getFirstByXPath(userPortalLoginXPath);
        if (usernameField == null) {
            LoginTest.info("User Name field not found in HTML. Probably login page didn't load.");
            this.exit(1);
        }
        if (passwordField == null) {
            LoginTest.info("Password field not found in HTML. Probably login page didn't load.");
            this.exit(1);
        }
        usernameField.setValueAttribute("admin");
        passwordField.setValueAttribute("admin");
        if (portalLogin == null) {
            LoginTest.info("Login button not found in HTML. Probably login page didn't load.");
            this.exit(1);
        } else {
            LoginTest.info("Portal login page obtained. Attempting login");
            try {
                portalLogin.click();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    private HtmlButton findLogoutButton(HtmlPage page) {
        HtmlButton logoutButton = (HtmlButton)page.getFirstByXPath("//button[text()='Log Off']");
        return logoutButton;
    }

    private boolean findLogoff(HtmlPage page) {
        return page.getFirstByXPath("//a[@class='logout']") != null;
    }

    private void test() throws Exception {
        this.webClient = new WebClient(BrowserVersion.INTERNET_EXPLORER_11);
        this.webClient.getOptions().setUseInsecureSSL(true);
        this.setLoginAlertHandler();
        if (this.runAPP) {
            LoginTest.info("Connecting to: " + this.portalUrl);
            HtmlPage page = (HtmlPage)this.webClient.getPage(this.portalUrl);
            this.wait(this.timeoutSecs);
            this.cmsLoginForm(page);
            this.wait(this.timeoutSecs);
            try {
                page = (HtmlPage)this.webClient.getPage(this.portalUrl);
            }
            catch (Exception exception) {
                LoginTest.info("Page didn't load.");
                this.exit(1);
            }
            this.wait(this.timeoutSecs);
            HtmlButton logoutButton = this.findLogoutButton(page);
            if (logoutButton == null) {
                LoginTest.info("Logout button not found in HTML. Probably home page didn't load.");
                this.exit(1);
            }
            LoginTest.info("Attempting logout");
            this.setLogoutAlertHandler();
            logoutButton.click();
            this.wait(this.timeoutSecs);
        }
        if (this.runPT) {
            this.htmlUnitDriver = new MyHtmlUnitDriver();
            if (!this.debug) {
                this.webClient = this.htmlUnitDriver.modifyWebClient(this.webClient);
            }
            LoginTest.info("Connecting to: " + this.userPortalUrl);
            HtmlPage userPortalPage = (HtmlPage)this.webClient.getPage(this.userPortalUrl);
            this.wait(this.timeoutSecs);
            this.userPortalLoginForm(userPortalPage);
            this.wait(this.timeoutSecs);
            userPortalPage = (HtmlPage)this.webClient.getPage(this.userPortalUrl);
            this.wait(this.timeoutSecs);
            if (!this.findLogoff(userPortalPage)) {
                LoginTest.info("Logoff button not found in HTML. Probably home page didn't load.");
                this.exit(1);
            }
            LoginTest.info("Attempting logout");
            userPortalPage = (HtmlPage)this.webClient.getPage(String.valueOf(this.userPortalUrl) + "/logout/index");
            this.wait(this.timeoutSecs);
            userPortalPage = (HtmlPage)this.webClient.getPage(this.userPortalUrl);
            this.wait(this.timeoutSecs);
            if (this.findLogoff(userPortalPage)) {
                LoginTest.info("Did not logoff.");
                this.exit(1);
            }
            this.wait(this.timeoutSecs);
        }
    }

    private void wait(int n) {
        LoginTest.info("Waiting " + n + " seconds for JavaScript to finish");
        this.webClient.waitForBackgroundJavaScript((long)(n * 1000));
    }

    private void exit(int status) {
        if (this.webClient != null) {
            this.webClient.close();
        }
        if (status == 0) {
            LoginTest.info("Exiting normally (status code = 0)");
        } else {
            LoginTest.info("Exiting abnormally (status code = " + status + ")");
        }
        System.exit(status);
    }

    private static void info(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        LoginTest test = null;
        if (args.length == 1) {
            test = new LoginTest(args[0]);
        } else if (args.length == 2) {
            test = new LoginTest(args[0], args[1]);
        } else if (args.length == 3) {
            test = new LoginTest(args[0], args[1], args[2]);
        } else if (args.length == 4) {
            test = args[3].equals("true") ? new LoginTest(args[0], args[1], args[2], true) : (args[3].equals("false") ? new LoginTest(args[0], args[1], args[2], false) : new LoginTest(args[0], args[1], args[2]));
        } else {
            System.out.println("Usage: LoginTest <host> (timeout secs) (app|pt|vip) (debug: true|false)");
            System.exit(1);
        }
        try {
            test.test();
        }
        catch (Exception e) {
            e.printStackTrace();
            test.exit(1);
        }
        test.exit(0);
    }

    public class MyHtmlUnitDriver
    extends HtmlUnitDriver {
        protected WebClient modifyWebClient(WebClient client) {
            WebClient modifiedClient = super.modifyWebClient(client);
            modifiedClient.getOptions().setThrowExceptionOnScriptError(false);
            return modifiedClient;
        }
    }
}

