/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=38.0f), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
public class HTMLAllCollection
extends HTMLCollection {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=38.0f)})
    public HTMLAllCollection() {
    }

    public HTMLAllCollection(DomNode parentScope, String description) {
        super(parentScope, false, description);
    }

    @Override
    @JsxFunction
    public Object item(Object index) {
        BrowserVersion browser;
        Double numb;
        if (index instanceof String) {
            String name = (String)index;
            Object result = this.namedItem(name);
            if (null != result && Undefined.instance != result) {
                return result;
            }
            numb = Double.NaN;
            browser = this.getBrowserVersion();
            if (!browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_DO_NOT_CONVERT_STRINGS_TO_NUMBER)) {
                numb = ScriptRuntime.toNumber((Object)index);
            }
            if (ScriptRuntime.NaN == numb || numb.isNaN()) {
                return this.itemNotFound(browser);
            }
        } else {
            numb = ScriptRuntime.toNumber((Object)index);
            browser = this.getBrowserVersion();
        }
        if (!browser.hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_ITEM_FUNCT_SUPPORTS_DOUBLE_INDEX_ALSO) && (Double.isInfinite(numb) || numb != Math.floor(numb))) {
            return this.itemNotFound(browser);
        }
        if (numb < 0.0 && browser.hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_EXCEPTION_FOR_NEGATIVE_INDEX)) {
            throw Context.reportRuntimeError((String)"Invalid index.");
        }
        Object object = this.get(numb.intValue(), (Scriptable)this);
        if (object == NOT_FOUND) {
            return this.itemNotFound(browser);
        }
        return object;
    }

    private Object itemNotFound(BrowserVersion browser) {
        if (browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_NULL_IF_ITEM_NOT_FOUND)) {
            return null;
        }
        return Undefined.instance;
    }

    @Override
    @JsxFunction
    public final Object namedItem(String name) {
        List<Object> elements = this.getElements();
        ArrayList<DomElement> matchingByName = new ArrayList<DomElement>();
        ArrayList<DomElement> matchingById = new ArrayList<DomElement>();
        BrowserVersion browser = this.getBrowserVersion();
        boolean byName = !browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_DO_NOT_CHECK_NAME);
        for (Object next : elements) {
            if (!(next instanceof DomElement)) continue;
            DomElement elem = (DomElement)next;
            String nodeName = elem.getAttribute("name");
            if (byName && name.equals(nodeName)) {
                matchingByName.add(elem);
                continue;
            }
            String id = elem.getAttribute("id");
            if (!name.equals(id)) continue;
            matchingById.add(elem);
        }
        matchingByName.addAll(matchingById);
        if (matchingByName.size() == 1 || matchingByName.size() > 1 && browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_NO_COLLECTION_FOR_MANY_HITS)) {
            return this.getScriptableForElement(matchingByName.get(0));
        }
        if (matchingByName.isEmpty()) {
            if (browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_NULL_IF_NAMED_ITEM_NOT_FOUND)) {
                return null;
            }
            return Undefined.instance;
        }
        DomNode domNode = this.getDomNodeOrNull();
        HTMLCollection collection = new HTMLCollection(domNode, matchingByName);
        collection.setAvoidObjectDetection(!browser.hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_OBJECT_DETECTION));
        return collection;
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if ((String.class.equals(hint) || hint == null) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_DEFAULT_DESCRIPTION)) {
            return "[object HTML document.all class]";
        }
        return super.getDefaultValue(hint);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_DO_NOT_SUPPORT_PARANTHESES)) {
            if (args.length == 0) {
                throw Context.reportRuntimeError((String)"Zero arguments; need an index or a key.");
            }
            if (args[0] instanceof Number) {
                return null;
            }
        }
        return super.call(cx, scope, thisObj, args);
    }

    @Override
    public String getClassName() {
        if (this.getWindow().getWebWindow() != null && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION)) {
            return "HTMLCollection";
        }
        return super.getClassName();
    }
}

