/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.remote.ExecuteMethod;

class RemoteMouse
implements Mouse {
    protected final ExecuteMethod executor;

    public RemoteMouse(ExecuteMethod executor) {
        this.executor = executor;
    }

    protected Map<String, Object> paramsFromCoordinates(Coordinates where) {
        HashMap params = Maps.newHashMap();
        if (where != null) {
            String id = (String)where.getAuxiliary();
            params.put("element", id);
        }
        return params;
    }

    protected void moveIfNeeded(Coordinates where) {
        if (where != null) {
            this.mouseMove(where);
        }
    }

    @Override
    public void click(Coordinates where) {
        this.moveIfNeeded(where);
        this.executor.execute("mouseClick", (Map<String, ?>)ImmutableMap.of((Object)"button", (Object)0));
    }

    @Override
    public void contextClick(Coordinates where) {
        this.moveIfNeeded(where);
        this.executor.execute("mouseClick", (Map<String, ?>)ImmutableMap.of((Object)"button", (Object)2));
    }

    @Override
    public void doubleClick(Coordinates where) {
        this.moveIfNeeded(where);
        this.executor.execute("mouseDoubleClick", (Map<String, ?>)ImmutableMap.of());
    }

    @Override
    public void mouseDown(Coordinates where) {
        this.moveIfNeeded(where);
        this.executor.execute("mouseButtonDown", (Map<String, ?>)ImmutableMap.of());
    }

    @Override
    public void mouseUp(Coordinates where) {
        this.moveIfNeeded(where);
        this.executor.execute("mouseButtonUp", (Map<String, ?>)ImmutableMap.of());
    }

    @Override
    public void mouseMove(Coordinates where) {
        Map<String, Object> moveParams = this.paramsFromCoordinates(where);
        this.executor.execute("mouseMoveTo", moveParams);
    }

    @Override
    public void mouseMove(Coordinates where, long xOffset, long yOffset) {
        Map<String, Object> moveParams = this.paramsFromCoordinates(where);
        moveParams.put("xoffset", xOffset);
        moveParams.put("yoffset", yOffset);
        this.executor.execute("mouseMoveTo", moveParams);
    }
}

