/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.automation.login;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoginTest {
    private static final String USERNAME = "admin";
    private static final String PASSWORD = "admin";
    private WebClient webClient;
    private String portalUrl;
    private int timeoutSecs = 30;

    public LoginTest(String string, String string2) {
        this.portalUrl = string;
        Logger.getLogger("com.gargoylesoftware").setLevel(Level.OFF);
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        try {
            this.timeoutSecs = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            this.timeoutSecs = 30;
        }
    }

    private void setLoginAlertHandler() {
        this.webClient.setAlertHandler(new AlertHandler(){

            public void handleAlert(Page page, String string) {
                LoginTest.info(String.format("Alerts @ Page: %s, Alert: %s", page, string));
                if (string.toLowerCase().contains("fail")) {
                    LoginTest.info("Word \"fail\" present in the alert");
                    LoginTest.this.exit(1);
                }
            }
        });
    }

    private void setLogoutAlertHandler() {
        this.webClient.setAlertHandler(new AlertHandler(){

            public void handleAlert(Page page, String string) {
                LoginTest.info(String.format("Alerts @ Page: %s, Alert: %s", page, string));
                if (!string.contains("Logged out successfully.")) {
                    LoginTest.info("Could not logout");
                    LoginTest.this.exit(1);
                }
            }
        });
    }

    private void submitLoginForm(HtmlPage htmlPage) throws Exception {
        String string = "//input[@name='j_username']";
        String string2 = "//input[@name='j_password']";
        String string3 = "//button[@type='submit']";
        String string4 = "//input[@type='submit']";
        HtmlTextInput htmlTextInput = (HtmlTextInput)htmlPage.getFirstByXPath(string);
        HtmlPasswordInput htmlPasswordInput = (HtmlPasswordInput)htmlPage.getFirstByXPath(string2);
        HtmlButton htmlButton = (HtmlButton)htmlPage.getFirstByXPath(string3);
        if (htmlTextInput == null) {
            LoginTest.info("User Name field not found in HTML. Probably login page didn't load.");
            this.exit(1);
        }
        if (htmlPasswordInput == null) {
            LoginTest.info("Password field not found in HTML. Probably login page didn't load.");
            this.exit(1);
        }
        if (htmlButton == null && (htmlButton = (HtmlButton)htmlPage.getFirstByXPath(string4)) == null) {
            LoginTest.info("Login button not found in HTML. Probably login page didn't load.");
            this.exit(1);
        }
        LoginTest.info("Login page obtained. Attempting login");
        htmlTextInput.setValueAttribute("admin");
        htmlPasswordInput.setValueAttribute("admin");
        htmlButton.click();
    }

    private HtmlButton findLogoutButton(HtmlPage htmlPage) {
        HtmlButton htmlButton = (HtmlButton)htmlPage.getFirstByXPath("//button[text()='Log Out']");
        return htmlButton;
    }

    private void test() throws Exception {
        this.webClient = new WebClient(BrowserVersion.INTERNET_EXPLORER_8);
        this.webClient.setUseInsecureSSL(true);
        this.setLoginAlertHandler();
        LoginTest.info("Connecting to: " + this.portalUrl);
        HtmlPage htmlPage = (HtmlPage)this.webClient.getPage(this.portalUrl);
        this.wait(this.timeoutSecs);
        this.submitLoginForm(htmlPage);
        this.wait(this.timeoutSecs);
        htmlPage = (HtmlPage)this.webClient.getPage(this.portalUrl);
        this.wait(this.timeoutSecs);
        HtmlButton htmlButton = this.findLogoutButton(htmlPage);
        if (htmlButton == null) {
            LoginTest.info("Logout button not found in HTML. Probably home page didn't load.");
            this.exit(1);
        }
        LoginTest.info("Attempting logout");
        this.setLogoutAlertHandler();
        htmlButton.click();
        this.wait(this.timeoutSecs);
    }

    private void wait(int n) {
        LoginTest.info("Waiting " + n + " seconds for JavaScript to finish");
        this.webClient.waitForBackgroundJavaScript((long)(n * 1000));
    }

    private void exit(int n) {
        if (this.webClient != null) {
            this.webClient.closeAllWindows();
        }
        if (n == 0) {
            LoginTest.info("Exiting normally (status code = 0)");
        } else {
            LoginTest.info("Exiting abnormally (status code = " + n + ")");
        }
        System.exit(n);
    }

    private static void info(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage: LoginTest <host> <timeout secs>");
            System.exit(1);
        }
        LoginTest loginTest = new LoginTest(stringArray[0], stringArray[1]);
        try {
            loginTest.test();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            loginTest.exit(1);
        }
        loginTest.exit(0);
    }
}

