/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.arrays;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(browsers={@WebBrowser(value=BrowserName.FF, minVersion=10.0f), @WebBrowser(value=BrowserName.CHROME)})
public class ArrayBuffer
extends SimpleScriptable {
    private byte[] bytes_;

    @JsxConstructor
    public void constructor(int length) {
        this.bytes_ = new byte[length];
    }

    @JsxGetter
    public int getByteLength() {
        return this.bytes_.length;
    }

    @JsxFunction
    public ArrayBuffer slice(int begin, Object end) {
        if (end == Undefined.instance) {
            end = this.getByteLength();
        }
        byte[] byteArray = new byte[((Number)end).intValue() - begin];
        System.arraycopy(this.bytes_, begin, byteArray, 0, byteArray.length);
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        arrayBuffer.bytes_ = byteArray;
        return arrayBuffer;
    }

    byte getByte(int index) {
        return this.bytes_[index];
    }

    void setBytes(int index, byte[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            this.bytes_[index + i] = array[i];
        }
    }

    @Override
    public String getClassName() {
        return "ArrayBuffer";
    }

    byte[] getBytes() {
        return this.bytes_;
    }
}

