/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlFileInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.InputElementFactory;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.PointerEvent;
import com.gargoylesoftware.htmlunit.javascript.host.file.FileList;
import com.gargoylesoftware.htmlunit.javascript.host.html.FormField;
import java.io.IOException;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.math.NumberUtils;
import org.xml.sax.helpers.AttributesImpl;

@JsxClasses(value={@JsxClass(domClass=HtmlInput.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)}), @JsxClass(domClass=HtmlInput.class, isJSObject=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class HTMLInputElement
extends FormField {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public HTMLInputElement() {
    }

    @JsxSetter
    public void setType(String newType) {
        HtmlInput input = this.getDomNodeOrDie();
        if (!input.getTypeAttribute().equalsIgnoreCase(newType)) {
            AttributesImpl attributes = this.readAttributes(input);
            int index = attributes.getIndex("type");
            attributes.setValue(index, newType);
            HtmlInput newInput = (HtmlInput)InputElementFactory.instance.createElement(input.getPage(), "input", attributes);
            if (input.wasCreatedByJavascript()) {
                newInput.markAsCreatedByJavascript();
            }
            if (input.getParentNode() != null) {
                input.getParentNode().replaceChild(newInput, input);
            } else {
                input = newInput;
            }
            input.setScriptObject(null);
            this.setDomNode(newInput, true);
        }
    }

    @JsxSetter
    public void setChecked(boolean checked) {
        this.getDomNodeOrDie().setChecked(checked);
    }

    @Override
    public HtmlInput getDomNodeOrDie() {
        return (HtmlInput)super.getDomNodeOrDie();
    }

    @JsxGetter
    public boolean getChecked() {
        return this.getDomNodeOrDie().isChecked();
    }

    @JsxFunction
    public void select() {
        HtmlInput input = this.getDomNodeOrDie();
        if (input instanceof HtmlTextInput) {
            ((HtmlTextInput)input).select();
        }
    }

    @Override
    public void setAttribute(String name, String value) {
        if ("type".equals(name)) {
            this.setType(value);
        } else {
            super.setAttribute(name, value);
        }
    }

    @JsxGetter
    public String getDefaultValue() {
        return this.getDomNodeOrDie().getDefaultValue();
    }

    @JsxSetter
    public void setDefaultValue(String defaultValue) {
        this.getDomNodeOrDie().setDefaultValue(defaultValue);
    }

    @JsxGetter
    public boolean getDefaultChecked() {
        return this.getDomNodeOrDie().isDefaultChecked();
    }

    @JsxSetter
    public void setDefaultChecked(boolean defaultChecked) {
        this.getDomNodeOrDie().setDefaultChecked(defaultChecked);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getTextLength() {
        return this.getValue().length();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.CHROME)})
    public int getSelectionStart() {
        return ((SelectableTextInput)((Object)this.getDomNodeOrDie())).getSelectionStart();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.CHROME)})
    public void setSelectionStart(int start) {
        ((SelectableTextInput)((Object)this.getDomNodeOrDie())).setSelectionStart(start);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.CHROME)})
    public int getSelectionEnd() {
        return ((SelectableTextInput)((Object)this.getDomNodeOrDie())).getSelectionEnd();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.CHROME)})
    public void setSelectionEnd(int end) {
        ((SelectableTextInput)((Object)this.getDomNodeOrDie())).setSelectionEnd(end);
    }

    @JsxGetter
    public int getMaxLength() {
        String attrValue = this.getDomNodeOrDie().getAttribute("maxLength");
        return NumberUtils.toInt((String)attrValue, (int)-1);
    }

    @JsxSetter
    public void setMaxLength(int length) {
        this.getDomNodeOrDie().setMaxLength(length);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public int getMinLength() {
        String attrValue = this.getDomNodeOrDie().getAttribute("minLength");
        return NumberUtils.toInt((String)attrValue, (int)-1);
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public void setMinLength(int length) {
        this.getDomNodeOrDie().setMinLength(length);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public String getMin() {
        return this.getDomNodeOrDie().getAttribute("min");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void setMin(String min) {
        this.getDomNodeOrDie().setAttribute("min", min);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public String getMax() {
        return this.getDomNodeOrDie().getAttribute("max");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void setMax(String max) {
        this.getDomNodeOrDie().setAttribute("max", max);
    }

    @JsxGetter
    public boolean getReadOnly() {
        return this.getDomNodeOrDie().isReadOnly();
    }

    @JsxSetter
    public void setReadOnly(boolean readOnly) {
        this.getDomNodeOrDie().setReadOnly(readOnly);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void setSelectionRange(int start, int end) {
        this.setSelectionStart(start);
        this.setSelectionEnd(end);
    }

    @JsxGetter
    public String getAlt() {
        return this.getDomNodeOrDie().getAttribute("alt");
    }

    @JsxSetter
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getBorder() {
        return this.getDomNodeOrDie().getAttribute("border");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        boolean ignoreIfNoError = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_FOR_INPUT_IGNORES_VALUES);
        this.setAlign(align, ignoreIfNoError);
    }

    @JsxGetter
    public String getSrc() {
        return this.getDomNodeOrDie().getSrcAttribute();
    }

    @Override
    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void click() throws IOException {
        HtmlInput domNode = this.getDomNodeOrDie();
        boolean originalState = domNode.isChecked();
        MouseEvent event = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLICK_USES_POINTEREVENT) ? new PointerEvent(domNode, "click", false, false, false, 0) : new MouseEvent(domNode, "click", false, false, false, 0);
        domNode.click(event);
        boolean newState = domNode.isChecked();
        if (originalState != newState && (domNode instanceof HtmlRadioButtonInput || domNode instanceof HtmlCheckBoxInput && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLICK_CHECKBOX_TRIGGERS_NO_CHANGE_EVENT))) {
            domNode.fireEvent("change");
        }
    }

    @Override
    @JsxGetter
    public String getType() {
        return super.getType();
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public boolean isRequired() {
        return this.getDomNodeOrDie().isRequired();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void setRequired(boolean required) {
        this.getDomNodeOrDie().setRequired(required);
    }

    @JsxGetter
    public String getSize() {
        return this.getDomNodeOrDie().getSize();
    }

    @JsxSetter
    public void setSize(String size) {
        this.getDomNodeOrDie().setSize(size);
    }

    @JsxGetter
    public String getAccept() {
        return this.getDomNodeOrDie().getAccept();
    }

    @JsxSetter
    public void setAccept(String accept) {
        this.getDomNodeOrDie().setAccept(accept);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public String getAutocomplete() {
        return this.getDomNodeOrDie().getAutocomplete();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void setAutocomplete(String autocomplete) {
        this.getDomNodeOrDie().setAutocomplete(autocomplete);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public Object getFiles() {
        if (this.getDomNodeOrDie() instanceof HtmlFileInput) {
            FileList list = new FileList(this.getValue().split("\u00a7"));
            list.setParentScope(this.getParentScope());
            list.setPrototype(this.getPrototype(list.getClass()));
            return list;
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLINPUT_FILES_UNDEFINED)) {
            return Undefined.instance;
        }
        return null;
    }
}

