/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.distribution.testplugin;

import com.ericsson.cms.sites.monitoring.common.AssetStatusBean;
import com.ericsson.cms.sites.monitoring.common.IAssetStatusBean;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryResult;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryServiceFacade;
import com.ericsson.cms.sites.monitoring.common.StatusQueryResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class FileBasedQueryServiceFacade
implements IStatusQueryServiceFacade {
    private static final Logger logger = Logger.getLogger((String)FileBasedQueryServiceFacade.class.getName());
    static int nextStatus = 0;
    private File csvDataFile;

    public FileBasedQueryServiceFacade(File csvDataFile) {
        this.csvDataFile = csvDataFile;
    }

    @Override
    public IStatusQueryResult getAssetStatus(long startIndex) throws SecurityException, IOException, ServiceException {
        IStatusQueryResult result = this.getDataFromFile();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatusQueryResult getDataFromFile() {
        BufferedReader buff = null;
        ArrayList<IAssetStatusBean> statusInfoList = new ArrayList<IAssetStatusBean>();
        ++nextStatus;
        try {
            String line;
            buff = new BufferedReader(new FileReader(this.csvDataFile));
            while ((line = buff.readLine()) != null) {
                String[] fields = line.split(",");
                AssetStatusBean info = null;
                info = new AssetStatusBean();
                info.setAssetID(fields[0]);
                info.setProviderID(fields[1]);
                info.setStatus(fields[2]);
                info.setTimestamp(Long.parseLong(fields[3]));
                statusInfoList.add(info);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error while reading csv file: ", (Throwable)ex);
        }
        finally {
            if (buff != null) {
                try {
                    buff.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Error while closing csv file: ", (Throwable)ex);
                }
            }
        }
        return new StatusQueryResult(statusInfoList, -1L);
    }
}

