/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.distribution.testplugin;

import com.ericsson.cms.sites.monitoring.common.IAssetStatusBean;
import com.ericsson.cms.sites.monitoring.common.IStatusListener;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryResult;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryServiceFacade;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryThread;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class FileBasedStatusThread
implements IStatusQueryThread {
    String url;
    Date lastUpdate = null;
    Set<String> externalIds = new HashSet<String>();
    IStatusQueryServiceFacade queryService = null;
    IStatusListener listener = null;
    private List<? extends IAssetStatusBean> statusChangesList = new ArrayList<IAssetStatusBean>();
    private String id = null;
    private static final Logger logger = Logger.getLogger((String)FileBasedStatusThread.class.getName());

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public IStatusListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(IStatusListener listener) {
        this.listener = listener;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public Set<String> getExternalIds() {
        return this.externalIds;
    }

    @Override
    public void setExternalIds(Set<String> externalIds) {
        this.externalIds = externalIds;
    }

    @Override
    public IStatusQueryServiceFacade getQueryService() {
        return this.queryService;
    }

    @Override
    public void setQueryService(IStatusQueryServiceFacade queryService) {
        this.queryService = queryService;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void execute() {
        this.listener.callStarted(this);
        if (this.externalIds.size() == 0) {
            logger.debug((Object)String.format("No external Ids. Existing run() for thread id: %s without making weservice call.%n", this.id));
            return;
        }
        try {
            IStatusQueryResult reply = this.queryService.getAssetStatus(0L);
            this.statusChangesList = reply.getAssets();
            if (this.listener != null && this.statusChangesList.size() > 0) {
                this.listener.statusChanged(this, this.statusChangesList);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while querying service to get results: ", (Throwable)e);
        }
        this.listener.callCompleted(this);
    }
}

