/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.distribution.testplugin;

import com.ericsson.cms.sites.monitoring.common.SingleTaskTimer;
import com.ericsson.cms.sites.monitoring.config.ConfigurationManager;
import com.ericsson.cms.sites.monitoring.config.IStatusPluginConfiguration;
import com.ericsson.cms.sites.monitoring.distribution.DistributionStatusPluginBase;
import com.ericsson.cms.sites.monitoring.distribution.testplugin.FileBasedQueryServiceFacade;
import com.ericsson.cms.sites.monitoring.distribution.testplugin.FileBasedStatusThread;
import com.ericsson.cms.sites.monitoring.distribution.testplugin.TestPluginConfigurationParser;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.java.plugin.registry.PluginDescriptor;

public class TestDistributionStatusPlugin
extends DistributionStatusPluginBase {
    private static final Logger logger = Logger.getLogger((String)TestDistributionStatusPlugin.class.getName());

    @Override
    protected Map<String, Map<String, String>> translateConfig(Map<String, IStatusPluginConfiguration> sourceMap) {
        HashMap<String, Map<String, String>> translatedMap = new HashMap<String, Map<String, String>>();
        for (String key : sourceMap.keySet()) {
            IStatusPluginConfiguration config = sourceMap.get(key);
            HashMap<String, String> configProperties = new HashMap<String, String>();
            configProperties.put("Display Name", config.getConfigurationDisplayName());
            configProperties.put("Configuration ID", config.getConfigurationId());
            configProperties.put("Asset Status Data File", config.getEndpointUrl());
            configProperties.put("Polling Interval", Long.toString(config.getPollInterval()));
            translatedMap.put(config.getConfigurationId(), configProperties);
        }
        return translatedMap;
    }

    @Override
    protected synchronized void _start() {
        try {
            logger.info((Object)"In TestDistributionStatusPlugin._start()...");
            if (this.started) {
                logger.warn((Object)"In TestDistributionStatusPlugin Already started");
                return;
            }
            this.multiConfiguration.clear();
            this.timerMap.clear();
            ClassLoader loader = this.getClass().getClassLoader();
            PluginDescriptor desc = this.getDescriptor();
            this.locateHomeDirectories(loader, desc);
            if (!this.tempDirectory.exists()) {
                this.tempDirectory.mkdir();
            }
            this.configurationManager = new ConfigurationManager();
            this.configParser = new TestPluginConfigurationParser();
            this.configMap = this.configurationManager.configure(this.configDirectory, this.configParser);
            this.multiConfiguration = this.translateConfig(this.configMap);
            this.startTimers(this.configMap);
        }
        catch (Exception ex) {
            logger.error((Object)"Error Starting new configuration threads", (Throwable)ex);
            this.stopAllTimers();
            this.started = false;
            return;
        }
        this.started = true;
    }

    @Override
    protected synchronized void startTimers(Map<String, IStatusPluginConfiguration> selectedConfigMap) {
        for (String key : selectedConfigMap.keySet()) {
            IStatusPluginConfiguration config = selectedConfigMap.get(key);
            FileBasedStatusThread thread = new FileBasedStatusThread();
            thread.setId(key);
            File csvDataFile = new File(this.configDirectory, config.getEndpointUrl());
            FileBasedQueryServiceFacade queryService = new FileBasedQueryServiceFacade(csvDataFile);
            thread.setListener(this);
            thread.setQueryService(queryService);
            SingleTaskTimer<FileBasedStatusThread> timer = new SingleTaskTimer<FileBasedStatusThread>(config.getPollInterval(), thread);
            timer.start();
            this.timerMap.put(key, timer);
            logger.info((Object)String.format("Started Thread: %s for configuration ID: %s%n", thread.getId(), key));
        }
    }
}

