/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.action.processing;

import com.tandbergtv.watchpoint.cms.action.SetTokenIdAction;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AddPosterOrPreviewToMetadata {
    private static final String XPATH_ADI_ASSET_NODE = "/ADI/Asset";
    private static final String XPATH_PACKAGE_PROVIDER = "/ADI/Metadata/AMS/@Provider";
    private static final String XPATH_PACKAGE_PRODUCT = "/ADI/Metadata/AMS/@Product";
    private static final String POSTER = "poster";
    private static final String PREVIEW = "preview";
    private static final String ASSET_ID = "assetId";
    private static final String APP = "App";
    private static final String NAME = "Name";
    private static final String VALUE = "Value";
    private static final String CONTENT_CHECKSUM = "Content_CheckSum";
    private static final String CONTENT_FILESIZE = "Content_FileSize";
    private static final String ADI_XML_FILE_PATH = "outputMetadataFile";
    private static final String POSTER_FILE_PATH = "posterFilePath";
    private static final String PREVIEW_FILE_PATH = "previewFilePath";
    private static final Logger logger = Logger.getLogger(SetTokenIdAction.class);
    private String packageProvider = null;
    private String packageProduct = null;
    private String ppFilePath = null;
    private Document doc = null;
    private String checksum = null;
    private String fileSize = null;

    public void addPoster(ExecutionContext context) throws Exception {
        this.add(POSTER, (String)context.getVariable(POSTER_FILE_PATH), (String)context.getVariable("posterChecksum"), (String)context.getVariable("posterFileSize"), context);
    }

    public void addPreview(ExecutionContext context) throws Exception {
        this.add(PREVIEW, (String)context.getVariable(PREVIEW_FILE_PATH), (String)context.getVariable("previewChecksum"), (String)context.getVariable("previewFileSize"), context);
    }

    private void add(String posterOrPreview, String ppFilePath, String checksum, String fileSize, ExecutionContext context) throws Exception {
        try {
            Document doc;
            logger.debug((Object)"Add_PP_Test: versaion 1003: ");
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver(null);
            this.doc = doc = docBuilder.parse(new File((String)context.getVariable(ADI_XML_FILE_PATH)));
            this.ppFilePath = ppFilePath;
            this.checksum = checksum;
            this.fileSize = fileSize;
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node adiAsset = (Node)xPath.evaluate(XPATH_ADI_ASSET_NODE, doc, XPathConstants.NODE);
            this.packageProvider = (String)xPath.evaluate(XPATH_PACKAGE_PROVIDER, doc, XPathConstants.STRING);
            this.packageProduct = (String)xPath.evaluate(XPATH_PACKAGE_PRODUCT, doc, XPathConstants.STRING);
            Element newAMS = this.createAMSElement(doc, adiAsset, posterOrPreview);
            this.createContentElement(newAMS.getParentNode().getParentNode());
            this.createApp_DataElements(newAMS.getParentNode(), posterOrPreview);
            this.writeDOMtoXmlFile(doc, (String)context.getVariable(ADI_XML_FILE_PATH));
        }
        catch (Exception e) {
            logger.debug((Object)("Add_PP_Test: exception thrown in method add(): " + e.getMessage()));
            throw e;
        }
    }

    private Element createAMSElement(Document doc, Node parentNode, String posterOrPreivew) {
        Element newAsset = doc.createElement("Asset");
        parentNode.appendChild(newAsset);
        Element newMetadata = doc.createElement("Metadata");
        newAsset.appendChild(newMetadata);
        Element newAMS = doc.createElement("AMS");
        newMetadata.appendChild(newAMS);
        this.setAMSAttributes(newAMS, posterOrPreivew);
        return newAMS;
    }

    private void setAMSAttributes(Node ams, String posterOrPreivew) {
        ((Element)ams).setAttribute("Asset_Class", posterOrPreivew);
        ((Element)ams).setAttribute("Asset_ID", this.generateAssetID(this.packageProvider, posterOrPreivew));
        ((Element)ams).setAttribute("Product", this.packageProduct);
        ((Element)ams).setAttribute("Provider", this.packageProvider);
    }

    private void createContentElement(Node parentNode) {
        Element newContent = this.doc.createElement("Content");
        parentNode.appendChild(newContent);
        newContent.setAttribute(VALUE, this.getFileName(this.ppFilePath));
    }

    private String getFileName(String filePath) {
        String[] tokens = filePath.split("/");
        if (tokens != null && tokens.length > 0) {
            return tokens[tokens.length - 1];
        }
        return "";
    }

    private void createApp_DataElements(Node parentNode, String posterOrPreview) {
        this.createApp_DataElement(parentNode, this.packageProduct, "Type", posterOrPreview);
        this.createApp_DataElement(parentNode, this.packageProduct, CONTENT_FILESIZE, this.fileSize);
        this.createApp_DataElement(parentNode, this.packageProduct, CONTENT_CHECKSUM, this.checksum);
    }

    private void createApp_DataElement(Node parentNode, String appAttr, String nameAttr, String valueAttr) {
        Element newApp_Data = this.doc.createElement("App_Data");
        parentNode.appendChild(newApp_Data);
        newApp_Data.setAttribute(APP, appAttr);
        newApp_Data.setAttribute(NAME, nameAttr);
        newApp_Data.setAttribute(VALUE, valueAttr);
    }

    private String generateAssetID(String base, String posterOrPreview) {
        Calendar cal = Calendar.getInstance();
        String timeInMills = String.valueOf(cal.getTimeInMillis());
        String assetID = base + timeInMills;
        assetID = posterOrPreview == POSTER ? assetID + "1" : assetID + "2";
        return assetID;
    }

    private void writeDOMtoXmlFile(Document doc, String outputFilePath) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMSource domSource = new DOMSource(doc);
        StreamResult markupResult = new StreamResult(new FileOutputStream(outputFilePath));
        transformer.transform(domSource, markupResult);
    }
}

