/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.ingest;

import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class ExtractTitleIdAssetIngest
implements ActionHandler {
    private static final long serialVersionUID = 8696287660000604659L;
    private static final String TITLE_ID_COLON = "titleId:";
    private static final String VALIDATION_SUCCESS = "Validation Success";
    private static final Logger logger = Logger.getLogger(ExtractTitleIdAssetIngest.class);

    public void execute(ExecutionContext context) throws Exception {
        String titlesMapped = this.getStringValue(context, "titlesMapped");
        int titleIdColonIndex = titlesMapped.indexOf(TITLE_ID_COLON);
        int vertBarIndex = titlesMapped.indexOf("|");
        if (titleIdColonIndex != -1 && vertBarIndex != -1) {
            String titleId = titlesMapped.substring(titleIdColonIndex + TITLE_ID_COLON.length(), vertBarIndex);
            context.setVariable("titleId", (Object)titleId);
        }
        if (titlesMapped.indexOf(VALIDATION_SUCCESS) != -1) {
            context.setVariable("result", (Object)"true");
        } else {
            context.setVariable("result", (Object)"false");
        }
        int lastVertBarIndex = titlesMapped.lastIndexOf("|");
        int closingBracketIndex = titlesMapped.indexOf("]");
        String mappedAssets = "";
        if (closingBracketIndex - lastVertBarIndex > 1) {
            int colonIndex = titlesMapped.indexOf(":", lastVertBarIndex);
            int commaIndex = titlesMapped.indexOf(",", lastVertBarIndex);
            if (commaIndex != -1) {
                String assetId;
                boolean firstTime = true;
                while (commaIndex != -1) {
                    assetId = titlesMapped.substring(colonIndex + 1, commaIndex);
                    if (firstTime) {
                        mappedAssets = mappedAssets + assetId;
                        firstTime = false;
                    } else {
                        mappedAssets = mappedAssets + "," + assetId;
                    }
                    colonIndex = titlesMapped.indexOf(":", commaIndex);
                    commaIndex = titlesMapped.indexOf(",", commaIndex + 1);
                }
                assetId = titlesMapped.substring(colonIndex + 1, closingBracketIndex);
                mappedAssets = mappedAssets + "," + assetId;
            } else {
                mappedAssets = titlesMapped.substring(colonIndex + 1, closingBracketIndex);
            }
        }
        logger.debug((Object)("titlesMapped=" + titlesMapped));
        logger.debug((Object)("mappedAssets=" + mappedAssets));
        context.setVariable("mappedAssets", (Object)mappedAssets);
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }
}

