/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.ingest;

import com.tandbergtv.watchpoint.cms.util.TemplateProperties;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.ConversionPropertyReader;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class InitializeProcessVariables
implements ActionHandler {
    private static final long serialVersionUID = -5476552838428097291L;
    private static final Logger logger = Logger.getLogger(InitializeProcessVariables.class);
    private static String PARTNER_DELIMITER = ",";
    private static String PROVIDERS_TO_RUN_SPEC_VALIDATION = "providersToRunSpecValidationOnIngest";

    public void execute(ExecutionContext context) throws Exception {
        long tokenId = context.getToken().getId();
        long processId = context.getProcessInstance().getId();
        context.setVariable("tokenId", (Object)Long.toString(tokenId));
        context.setVariable("processId", (Object)Long.toString(processId));
        context.setVariable("createTitleIfNotExist", (Object)false);
        context.setVariable("_external_page", (Object)false);
        context.setVariable("_externally_performed", (Object)true);
        String providerId = (String)context.getVariable("providerId");
        String specValidationProviders = TemplateProperties.getString(PROVIDERS_TO_RUN_SPEC_VALIDATION);
        if (specValidationProviders == null || specValidationProviders.isEmpty()) {
            specValidationProviders = "true";
        } else {
            String[] providers = specValidationProviders.split(PARTNER_DELIMITER);
            if (this.contains(providers, providerId)) {
                context.setVariable("runSpecValidation", (Object)true);
            } else {
                context.setVariable("runSpecValidation", (Object)false);
                logger.debug((Object)("Provider list [" + specValidationProviders + "] does not contain provider: " + providerId));
            }
        }
        context.setVariable("sourceComponentName", (Object)"WatchPoint");
        context.setVariable("sourceEntityName", (Object)"Workflow");
        context.setVariable("sourceId", (Object)(Long.toString(processId) + "|" + Long.toString(tokenId)));
        String providerList = ConversionPropertyReader.getProperty(ConversionPropertyReader.PARTNERS_WITH_METADATA);
        if (providerList == null || providerList.trim().length() == 0) {
            logger.debug((Object)("Provider list not provided in conversion.properties, so assuming that metadata is not complete for provider: " + providerId));
            context.setVariable("isProviderWithCompleteMetadata", (Object)false);
        } else {
            String[] providers = providerList.split(PARTNER_DELIMITER);
            if (this.contains(providers, providerId)) {
                context.setVariable("isProviderWithCompleteMetadata", (Object)true);
            } else {
                context.setVariable("isProviderWithCompleteMetadata", (Object)false);
                logger.debug((Object)("Provider list [" + providerList + "] does not contain provider: " + providerId));
            }
        }
        context.setVariable("titleBriefXPath", (Object)TemplateProperties.getString("TITLE_BRIEF_XPATH"));
        context.setVariable("licensingWindowStartXPath", (Object)TemplateProperties.getString("LICENSING_WINDOW_START_XPATH"));
        context.setVariable("licensingWindowEndXPath", (Object)TemplateProperties.getString("LICENSING_WINDOW_END_XPATH"));
        context.setVariable("itemType", (Object)"TITLE");
        String titleSearchURL = TemplateProperties.getString("AssetArrival.TitleSearchURL") + "SELECT";
        context.setVariable("titleSearchURL", (Object)titleSearchURL);
        context.setVariable("vodLookupKey", (Object)"VOD");
    }

    private boolean contains(String[] providers, String providerId) {
        for (int i = 0; i < providers.length; ++i) {
            if (!providers[i].trim().equalsIgnoreCase(providerId)) continue;
            return true;
        }
        return false;
    }
}

