/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.ingest;

import com.tandbergtv.watchpoint.cms.action.ActionException;
import com.tandbergtv.watchpoint.cms.util.DateUtility;
import com.tandbergtv.watchpoint.cms.util.PathProperties;
import java.io.File;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class InitializeProcessVariablesForPackage
implements ActionHandler {
    private static final long serialVersionUID = -5476552838428097291L;
    private static final String FOLDER_DATE_FORMAT = "folder.date.format";
    private static final Logger logger = Logger.getLogger(InitializeProcessVariablesForPackage.class);

    public void execute(ExecutionContext context) throws Exception {
        String packageFolderName;
        File packageFolder;
        String contentPath = PathProperties.getProperty("contentPath");
        if (contentPath == null || contentPath.trim().length() == 0) {
            throw new ActionException("The configured content folder does not have a value specified.");
        }
        File contentFile = new File(contentPath);
        if (!contentFile.exists()) {
            throw new ActionException("The configured content folder: " + contentFile.getAbsolutePath() + " does not exist.");
        }
        String providerId = (String)context.getVariable("providerId");
        if (providerId == null || providerId.trim().length() == 0) {
            throw new ActionException("The Provider Id does not have a value specified.");
        }
        File providerFolder = new File(contentFile, providerId);
        if (!providerFolder.exists() && !providerFolder.mkdir()) {
            throw new ActionException("The content folder for Provider[" + providerId + "]: " + providerFolder.getAbsolutePath() + " could not be created.");
        }
        if (!providerFolder.isDirectory()) {
            throw new ActionException("The content folder for Provider[" + providerId + "]: " + providerFolder.getAbsolutePath() + " is not a folder.");
        }
        String date = DateUtility.formatDate(new Date(), FOLDER_DATE_FORMAT);
        String originalAssetPath = date + File.separator + PathProperties.getProperty("provider.original.asset");
        File originalAssetFolder = new File(providerFolder, originalAssetPath);
        String archivePath = (String)context.getVariable("filePath");
        File archiveFile = new File(archivePath);
        String name = archiveFile.getName();
        int index = name.lastIndexOf(".");
        if (index != -1) {
            name = name.substring(0, index);
        }
        if (!(packageFolder = new File(originalAssetFolder, packageFolderName = name + "_" + System.currentTimeMillis())).mkdirs()) {
            throw new ActionException("Failed to create new content folder: " + packageFolder.getAbsolutePath() + " for extracting archive file: " + archivePath);
        }
        String targetFolderPath = packageFolder.getAbsolutePath();
        context.setVariable("extractFilePath", (Object)targetFolderPath);
        logger.debug((Object)"extractFilePath=extractFilePath");
        long fileSize = archiveFile.length();
        context.setVariable("fileSize", (Object)fileSize);
        long maxUntarTimeInSec = 1800L + (long)(2.2E-4 * (double)fileSize / 1024.0);
        context.setVariable("maxUntarTimeInSec", (Object)maxUntarTimeInSec);
    }
}

