/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.ingest;

import com.tandbergtv.watchpoint.cms.action.ActionException;
import com.tandbergtv.watchpoint.cms.util.FilePermissionUtility;
import com.tandbergtv.watchpoint.cms.util.PathProperties;
import java.io.File;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class MakeUnmappedFilesDirectory
implements ActionHandler {
    private static final long serialVersionUID = -5933623971869147450L;

    public void execute(ExecutionContext context) throws Exception {
        String unmappedFileDirName;
        String filePath = this.getStringValue(context, "mapFilePath");
        File file = new File(filePath);
        String providerId = this.getStringValue(context, "providerId");
        File providerDir = PathProperties.getUnmappedProviderFolder(providerId);
        File unmappedFileDir = new File(providerDir, unmappedFileDirName = file.getName() + "_" + System.currentTimeMillis());
        if (!unmappedFileDir.mkdirs()) {
            throw new ActionException("Unable to create directory: " + unmappedFileDir);
        }
        FilePermissionUtility.setPermissions(unmappedFileDir);
        File unmappedFile = new File(unmappedFileDir, file.getName());
        context.setVariable("unmappedMapFilePath", (Object)unmappedFile.getAbsolutePath());
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }
}

