/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.ingest;

import com.tandbergtv.watchpoint.cms.util.PathConverter;
import com.tandbergtv.watchpoint.cms.util.PathProperties;
import com.tandbergtv.watchpoint.cms.util.TemplateProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class SetFilePaths
implements ActionHandler {
    private static final long serialVersionUID = -4845781453389373424L;
    private static final String METADATA_FILE_EXTENSION = ".xml";
    public static String ASSET_PROCESSING_PROPERTIES = "/cms-template-actions/contentProcessing.properties";

    public void execute(ExecutionContext context) throws Exception {
        String contentPath = this.getStringValue(context, "extractFilePath");
        File contentFolder = new File(contentPath);
        String[] fileNames = contentFolder.list();
        if (fileNames == null) {
            throw new IOException("Unable to get list of files for directory: " + contentFolder);
        }
        String titleSearchURL = TemplateProperties.getString("AssetArrival.TitleSearchURL") + "SELECT";
        for (String fileName : fileNames) {
            if (this.isMetadataFile(fileName)) {
                String metadataFilePath = contentPath + File.separator + fileName;
                context.setVariable("isMetadataFile", (Object)true);
                context.setVariable("metadataFilePath", (Object)metadataFilePath);
            } else {
                String assetFilePath = contentPath + File.separator + fileName;
                String assetFilePathUNC = PathConverter.getInstance().convertUnixToUNC(assetFilePath);
                context.setVariable("mapFilePath", (Object)assetFilePath);
                context.setVariable("mapFilePathUNC", (Object)assetFilePathUNC);
                context.setVariable("isMetadataFile", (Object)false);
            }
            context.setVariable("fileName", (Object)fileName);
            int lastDotIndex = fileName.lastIndexOf(".");
            if (lastDotIndex == -1) continue;
            String fileExtension = fileName.substring(lastDotIndex).toLowerCase();
            context.setVariable("inputFileExtension", (Object)fileExtension);
        }
        context.setVariable("titleSearchURL", (Object)titleSearchURL);
        InputStream stream = this.getClass().getResourceAsStream(ASSET_PROCESSING_PROPERTIES);
        Properties config = new Properties();
        config.load(stream);
        String internalSpec = config.getProperty("spec.internal.format");
        context.setVariable("spec", (Object)internalSpec);
        String tempFolder = PathProperties.getProperty("tempContentPath");
        long processId = context.getProcessInstance().getId();
        String outputMetadataFileName = processId + "_TTV_METADATA.XML";
        String outputMetadataFilePath = tempFolder + File.separator + outputMetadataFileName;
        context.setVariable("outputMetadataFilePath", (Object)outputMetadataFilePath);
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }

    private boolean isMetadataFile(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.toLowerCase().endsWith(METADATA_FILE_EXTENSION);
    }
}

