/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.ingest;

import java.io.File;
import java.io.IOException;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class SetFilePathsForPackage
implements ActionHandler {
    private static final long serialVersionUID = -4845781453389373424L;
    private static final String METADATA_FILE_EXTENSION = ".xml";

    public void execute(ExecutionContext context) throws Exception {
        String contentPath = this.getStringValue(context, "extractFilePath");
        File contentFolder = new File(contentPath);
        String[] fileNames = contentFolder.list();
        if (fileNames == null) {
            throw new IOException("Unable to get list of files for directory: " + contentFolder);
        }
        String commaSepListOfFileNames = "";
        for (String fileName : fileNames) {
            if (this.isMetadataFile(fileName)) {
                String metadataFilePath = contentPath + File.separator + fileName;
                context.setVariable("metadataFilePath", (Object)metadataFilePath);
                continue;
            }
            commaSepListOfFileNames = commaSepListOfFileNames.equals("") ? contentPath + File.separator + fileName : commaSepListOfFileNames + "," + contentPath + File.separator + fileName;
        }
        context.setVariable("assetFileNames", (Object)commaSepListOfFileNames);
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }

    private boolean isMetadataFile(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.toLowerCase().endsWith(METADATA_FILE_EXTENSION);
    }
}

