/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.content.ingest;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class UpdateLoopVariablesAssetIngest
implements ActionHandler {
    private static final long serialVersionUID = 4860895485280005433L;
    private static final Logger logger = Logger.getLogger(UpdateLoopVariablesAssetIngest.class);

    public void execute(ExecutionContext context) throws IOException {
        String assetIds = this.getStringValue(context, "mappedAssets");
        String fileAssetIds = this.getStringValue(context, "fileAssetIds");
        logger.debug((Object)("assetIds=" + assetIds));
        logger.debug((Object)("fileAssetIds=" + fileAssetIds));
        List<String> assetIdList = this.convertCommaSepListtoList(assetIds);
        List<String> fileAssetIdList = this.convertCommaSepListtoList(fileAssetIds);
        int loopIndex = this.getIntegerValue(context, "mapFileIndex", -1) + 1;
        String assetId = assetIdList.get(loopIndex).trim();
        String fileAssetId = fileAssetIdList.get(loopIndex).trim();
        boolean hasMoreFiles = loopIndex + 1 < assetIdList.size();
        context.setVariable("currentAssetId", (Object)assetId);
        context.setVariable("currentFileAssetId", (Object)fileAssetId);
        context.setVariable("hasMoreMapFiles", (Object)hasMoreFiles);
        context.setVariable("mapFileIndex", (Object)loopIndex);
        context.setVariable("mapFileCount", (Object)new Integer(assetIdList.size()));
    }

    private List<String> convertCommaSepListtoList(String commaSepList) {
        return Arrays.asList(commaSepList.split(","));
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }

    private int getIntegerValue(ExecutionContext context, String variableName, int defaultValue) {
        int intValue = defaultValue;
        Object value = context.getVariable(variableName);
        if (value == null) {
            intValue = defaultValue;
        } else if (value instanceof Integer) {
            intValue = (Integer)value;
        } else {
            try {
                intValue = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("Failed to parse value: " + value + " to an integer when getting Asset Mapping Loop Index, " + "using default value: " + defaultValue), (Throwable)e);
            }
        }
        return intValue;
    }
}

