/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.schedule.ingest;

import com.tandbergtv.watchpoint.cms.action.schedule.ingest.converter.IScheduleConverter;
import com.tandbergtv.watchpoint.cms.util.PathProperties;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.ConversionHelper;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.ConversionResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ScheduleConversionAction
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ScheduleConversionAction.class);
    private static String ARCHIVE_FILEPATH = "archiveFilepath";
    private static String PROVIDER_ID = "providerId";
    private static String FILE_TYPE = "type";
    private static String CONVERTED_TEMP_FILE_PATH = "convertedTempFilepath";
    private static String FAILED_TITLE = "failedTitle";
    private static String PROCESS_ID = "processId";
    private static String TOKEN_ID = "tokenId";
    private static String CONVERSION_ERROR_MESSAGE = "conversionErrorMsg";
    private static final String SPEC = "spec";
    private static String TEMP_FILE_DELIMITER = "_";
    private static String CONVERTER_CONFIG = "/cms-template-actions/scheduleConverters.xml";
    private static String CONVERTER_CLASS_ELEMENT = "class";

    public void execute(ExecutionContext context) throws Exception {
        String folderPath;
        boolean foundConverter = false;
        List<IScheduleConverter> converterList = this.getConverters();
        logger.debug((Object)("Got " + converterList.size() + " converter(s)."));
        String inputFilepath = (String)context.getVariable(ARCHIVE_FILEPATH);
        try {
            folderPath = PathProperties.getProperty("tempContentPath");
        }
        catch (RuntimeException e2) {
            String errorMsg = "'tempContentPath' not defined in path.properties";
            context.setVariable(CONVERSION_ERROR_MESSAGE, (Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        String inputFileName = ConversionHelper.getFilename(inputFilepath);
        String tempFilename = String.valueOf((Integer)context.getVariable(PROCESS_ID)) + TEMP_FILE_DELIMITER + String.valueOf((Integer)context.getVariable(TOKEN_ID)) + TEMP_FILE_DELIMITER + inputFileName;
        String outputFilepath = ConversionHelper.generateFileName(folderPath, tempFilename);
        for (int i = 0; i < converterList.size(); ++i) {
            ConversionResult result;
            IScheduleConverter converter;
            block10: {
                converter = converterList.get(i);
                try {
                    boolean canConvert = converter.canConvert(inputFilepath);
                    if (!canConvert) {
                        logger.debug((Object)(converter.getClass().getName() + "cannot convert " + inputFilepath + " to PMM format planner/program list."));
                    }
                    break block10;
                }
                catch (RuntimeException e1) {
                    logger.warn((Object)("Failed to determine if converter: " + converter.getClass().getName() + " can convert: " + inputFilepath), (Throwable)e1);
                }
                continue;
            }
            foundConverter = true;
            try {
                result = converter.convert(inputFilepath, outputFilepath);
            }
            catch (RuntimeException e) {
                context.setVariable(CONVERSION_ERROR_MESSAGE, (Object)e.getMessage());
                throw new Exception(e.getMessage());
            }
            if (result.getErrorMsg() != null && result.getErrorMsg().trim().length() > 0) {
                context.setVariable(CONVERSION_ERROR_MESSAGE, (Object)result.getErrorMsg());
                context.setVariable(FAILED_TITLE, (Object)result.getFailedTitle());
                throw new Exception(result.getErrorMsg());
            }
            File outfile = new File(outputFilepath);
            if (!outfile.exists()) continue;
            context.setVariable(FILE_TYPE, (Object)result.getFileType().getValue());
            context.setVariable(CONVERTED_TEMP_FILE_PATH, (Object)outputFilepath);
            context.setVariable(SPEC, (Object)result.getSpec());
            String providerId = (String)context.getVariable(PROVIDER_ID);
            logger.info((Object)("Incoming file is a " + result.getFileType().getValue() + " from providerId: " + providerId));
            logger.info((Object)("Converted incoming file. Output filepath: " + outputFilepath));
            break;
        }
        if (!foundConverter) {
            String errorMsg = "No suitable converter found for file: " + inputFilepath;
            context.setVariable(CONVERSION_ERROR_MESSAGE, (Object)errorMsg);
            throw new Exception(errorMsg);
        }
    }

    private List<IScheduleConverter> getConverters() {
        ArrayList<IScheduleConverter> converters = new ArrayList<IScheduleConverter>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(this.getClass().getResourceAsStream(CONVERTER_CONFIG));
            NodeList converterClasses = doc.getElementsByTagName(CONVERTER_CLASS_ELEMENT);
            for (int i = 0; i < converterClasses.getLength(); ++i) {
                try {
                    Class<?> converter = Class.forName(converterClasses.item(i).getTextContent());
                    converters.add((IScheduleConverter)converter.newInstance());
                    continue;
                }
                catch (DOMException e) {
                    logger.error((Object)e.toString());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)e.toString());
                    continue;
                }
                catch (InstantiationException e) {
                    logger.error((Object)e.toString());
                    continue;
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e.toString());
                }
            }
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e.toString());
        }
        catch (SAXException e) {
            logger.error((Object)e.toString());
        }
        catch (IOException e) {
            logger.error((Object)e.toString());
        }
        return converters;
    }
}

