/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.schedule.ingest;

import com.tandbergtv.watchpoint.cms.util.schedule.ingest.ConversionHelper;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.FileType;
import java.io.File;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class SetCMSSchedulePath
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SetCMSSchedulePath.class);
    private static String PROVIDER_ID = "providerId";
    private static String INCOMING_FILE_TYPE = "type";
    private static String FILEPATH = "filePath";
    private static String CONVERTED_FILEPATH = "convertedFilepath";
    private static String PROCESS_ID = "processId";
    private static String FILE_NAME_DELIMITER = "_";

    public void execute(ExecutionContext context) throws Exception {
        String providerId = (String)context.getVariable(PROVIDER_ID);
        String type = (String)context.getVariable(INCOMING_FILE_TYPE);
        String inputFilepath = (String)context.getVariable(FILEPATH);
        String outputFolder = ConversionHelper.getOutputPath(providerId, FileType.getFileType(type));
        File dirFile = new File(outputFolder);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        String outputFilename = context.getVariable(PROCESS_ID) + FILE_NAME_DELIMITER + ConversionHelper.getFilename(inputFilepath);
        String outputPath = ConversionHelper.generateFileName(outputFolder, outputFilename);
        context.setVariable(CONVERTED_FILEPATH, (Object)outputPath);
        logger.debug((Object)("Set converted file path to: " + outputPath));
        long tokenId = context.getToken().getId();
        long processId = context.getProcessInstance().getId();
        context.setVariable("sourceComponentName", (Object)"WatchPoint");
        context.setVariable("sourceEntityName", (Object)"Workflow");
        context.setVariable("sourceId", (Object)(Long.toString(processId) + "|" + Long.toString(tokenId)));
    }
}

