/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.schedule.ingest;

import com.tandbergtv.watchpoint.cms.util.DateUtility;
import com.tandbergtv.watchpoint.cms.util.PathProperties;
import com.tandbergtv.watchpoint.cms.util.schedule.ingest.FileType;
import java.io.File;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class SetFileArchivalPathAction
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private static final String ARCHIVE_FILE_PATH = "archiveFilepath";
    private static String FILEPATH = "filePath";
    private static String FILE_TYPE = "type";
    private static String SOURCE_PROVIDER_ID = "providerId";
    private static String PROCESS_ID = "processId";
    private static final String FOLDER_DATE_FORMAT = "folder.date.format";
    private static String FILE_NAME_DELIMITER = "_";
    private static final Logger logger = Logger.getLogger(SetFileArchivalPathAction.class);

    public void execute(ExecutionContext context) throws Exception {
        String root = PathProperties.getProperty("contentPath");
        String providerId = (String)context.getVariable(SOURCE_PROVIDER_ID);
        String archiveFolder = "";
        String fileType = (String)context.getVariable(FILE_TYPE);
        String date = DateUtility.formatDate(new Date(), FOLDER_DATE_FORMAT);
        if (fileType.equals(FileType.PROGRAM_LIST.getValue())) {
            String programListPath = PathProperties.getProperty("provider.original.programList");
            archiveFolder = root + File.separator + providerId + File.separator + date + File.separator + programListPath;
        } else {
            String plannerPath = PathProperties.getProperty("provider.original.planner");
            archiveFolder = root + File.separator + providerId + File.separator + date + File.separator + plannerPath;
        }
        File dirFile = new File(archiveFolder);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        String inputFilepath = (String)context.getVariable(FILEPATH);
        File inputFile = new File(inputFilepath);
        String archiveFilePath = archiveFolder + File.separator + context.getVariable(PROCESS_ID) + FILE_NAME_DELIMITER + inputFile.getName();
        context.setVariable(ARCHIVE_FILE_PATH, (Object)archiveFilePath);
        logger.debug((Object)("Set archivePath to: " + archiveFilePath));
    }
}

