/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.cms.action.schedule.ingest;

import com.tandbergtv.watchpoint.cms.util.PathProperties;
import java.io.File;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class UpdateLoopVariables
implements ActionHandler {
    private static final String MORE_TITLES = "moreTitles";
    private static final String LOOP_OUTPUT_METADATA_FILE_PATH = "loopOutputMetadataFilePath";
    private static final String TOKEN_ID = "tokenId";
    private static final String LOOP_TITLE_ID = "loopTitleId";
    private static final String LOOP_TITLE_IDS_LIST = "loopTitleIdsList";
    private static final String SOURCE_PROVIDER_ID = "providerId";
    private static final long serialVersionUID = 2434081168396299089L;
    private static final Logger logger = Logger.getLogger(UpdateLoopVariables.class);

    public void execute(ExecutionContext context) throws Exception {
        String tokenId = this.getStringValue(context, TOKEN_ID);
        String commaSepListOfTitleIds = this.getStringValue(context, LOOP_TITLE_IDS_LIST);
        logger.debug((Object)("commaSepListOfTitleIds=" + commaSepListOfTitleIds));
        String assetFolder = this.getAssetFolder(this.getStringValue(context, SOURCE_PROVIDER_ID));
        int colonIndex = commaSepListOfTitleIds.indexOf(":");
        int commaIndex = commaSepListOfTitleIds.indexOf(",");
        if (colonIndex != -1 && commaIndex != -1 && colonIndex < commaIndex) {
            String loopTitleId = commaSepListOfTitleIds.substring(colonIndex + 1, commaIndex).trim();
            logger.debug((Object)("loopTitleId=" + loopTitleId));
            if (!loopTitleId.equals("")) {
                context.setVariable(LOOP_TITLE_IDS_LIST, (Object)commaSepListOfTitleIds.substring(commaIndex + 1));
                String loopOutputMetadataFilePath = assetFolder + File.separator + loopTitleId + "_" + tokenId + "_metadata.xml";
                context.setVariable(LOOP_TITLE_ID, (Object)loopTitleId);
                context.setVariable(LOOP_OUTPUT_METADATA_FILE_PATH, (Object)loopOutputMetadataFilePath);
                context.setVariable(MORE_TITLES, (Object)true);
            } else {
                context.setVariable(MORE_TITLES, (Object)false);
            }
        } else {
            context.setVariable(MORE_TITLES, (Object)false);
        }
    }

    private String getStringValue(ExecutionContext context, String variableName) {
        Object value = context.getVariable(variableName);
        return value != null ? value.toString() : null;
    }

    private String getAssetFolder(String providerId) {
        String contentPath = PathProperties.getProperty("contentPath");
        String assetFolder = PathProperties.getProperty("provider.ingest.asset");
        String assetPath = contentPath + File.separator + providerId + File.separator + assetFolder;
        File file = new File(assetPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return assetPath;
    }
}

